/*
 * Decompiled with CFR 0.152.
 */
package com.james.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class TouchAreaView
extends RelativeLayout {
    private Context context;

    public TouchAreaView(Context context) {
        super(context);
        this.context = context;
        this.setTouchAreaView();
    }

    private void setTouchAreaView() {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.setDrawingCacheEnabled(true);
    }

    public void addMovingSticker(Bitmap bitmap) {
        this.addMovingSticker(bitmap, bitmap.getWidth(), bitmap.getHeight());
    }

    public void addMovingSticker(Bitmap bitmap, int n, int n2) {
        final ImageView imageView = new ImageView(this.context);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        ((RelativeLayout.LayoutParams)imageView.getLayoutParams()).setMargins(this.getWidth() / 2, this.getHeight() / 2, 0, 0);
        imageView.setImageBitmap(bitmap);
        this.addView((View)imageView);
        imageView.setOnTouchListener(new View.OnTouchListener(){
            int lastX;
            int lastY;

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    imageView.setBackgroundColor(-855703552);
                    this.lastX = (int)motionEvent.getRawX();
                    this.lastY = (int)motionEvent.getRawY();
                } else if (motionEvent.getAction() == 2) {
                    int n = (int)motionEvent.getRawX() - this.lastX;
                    int n2 = (int)motionEvent.getRawY() - this.lastY;
                    view.layout(view.getLeft() + n, view.getTop() + n2, view.getRight() + n, view.getBottom() + n2);
                    view.postInvalidate();
                    this.lastX = (int)motionEvent.getRawX();
                    this.lastY = (int)motionEvent.getRawY();
                } else if (motionEvent.getAction() == 1) {
                    ((RelativeLayout.LayoutParams)view.getLayoutParams()).setMargins(view.getLeft(), view.getTop(), 0, 0);
                    imageView.setBackgroundColor(0);
                }
                return true;
            }
        });
    }

    public void addSimpleSticker(Bitmap bitmap, float f, float f2) {
        this.addSimpleSticker(bitmap, f, f2, bitmap.getWidth(), bitmap.getHeight());
    }

    public void addSimpleSticker(Bitmap bitmap, float f, float f2, int n, int n2) {
        ImageView imageView = new ImageView(this.context);
        imageView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n2));
        ((RelativeLayout.LayoutParams)imageView.getLayoutParams()).setMargins((int)f - n / 2, (int)f2 - n2 / 2, 0, 0);
        imageView.setImageBitmap(bitmap);
        this.addView((View)imageView);
    }
}

