/*
 * Decompiled with CFR 0.152.
 */
package com.james.views.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.james.easyclass.R;
import com.james.utils.MonitorUtils;
import com.james.views.FreeLayout;
import com.james.views.FreeTextView;
import java.util.ArrayList;

public class EasyProgressDialog
extends Dialog {
    private static EasyProgressDialog dialog;
    private Activity activity;
    boolean canceledOnTouchOutside = true;
    private FreeLayout dialogLayout;
    private Animation dismissAnimation;
    private ArrayList<View> dismissViews = new ArrayList();
    private CustomProgressBar progressBar;
    private FreeTextView progressText;
    private Animation showAnimation;

    public EasyProgressDialog(Activity activity) {
        super((Context)activity, 0x1030010);
        this.activity = activity;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dismissSelf() {
        try {
            EasyProgressDialog easyProgressDialog = dialog;
            if (easyProgressDialog == null) return;
            easyProgressDialog.dismiss();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private Animation getDismissAnimation() {
        if (this.dismissAnimation == null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
            alphaAnimation.setDuration(250L);
            this.dismissAnimation = alphaAnimation;
        }
        return this.dismissAnimation;
    }

    private Animation getShowAnimation() {
        if (this.showAnimation == null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration(500L);
            this.showAnimation = alphaAnimation;
        }
        return this.showAnimation;
    }

    private void init() {
        FreeLayout freeLayout = new FreeLayout(this.getContext());
        freeLayout.setFreeLayoutFF();
        freeLayout.setBackgroundColor(-1728053248);
        Object object = (FreeLayout)freeLayout.addFreeView((View)new FreeLayout(this.getContext()), 550, -2, new int[]{13});
        this.dialogLayout = object;
        object.setBackgroundResource(R.drawable.dialog_bg);
        freeLayout.setPadding((View)this.dialogLayout, 0, 35, 0, 35);
        object = (CustomProgressBar)this.dialogLayout.addFreeView(new CustomProgressBar(this.getContext()), 90, 90, new int[]{14});
        this.progressBar = object;
        ((CustomProgressBar)((Object)object)).setVisibility(4);
        FreeLayout freeLayout2 = this.dialogLayout;
        FreeTextView freeTextView = new FreeTextView(this.getContext());
        object = this.progressBar;
        object = (FreeTextView)freeLayout2.addFreeView((View)freeTextView, -2, -2, new int[]{14}, (View)object, new int[]{3});
        this.progressText = object;
        object.setTextColor(-10395295);
        this.progressText.setTextSizeFitResolution(33.0f);
        this.progressText.setGravity(17);
        this.progressText.setVisibility(8);
        this.dialogLayout.setPadding((View)this.progressText, 25, 10, 25, 10);
        object = freeLayout.addFreeView(new View(this.getContext()), -1, -1, (View)this.dialogLayout, new int[]{2});
        object.setBackgroundColor(0);
        this.dismissViews.add((View)object);
        object = freeLayout.addFreeView(new View(this.getContext()), -1, -1, (View)this.dialogLayout, new int[]{3});
        object.setBackgroundColor(0);
        this.dismissViews.add((View)object);
        object = freeLayout.addFreeView(new View(this.getContext()), -1, -1, (View)this.dialogLayout, new int[]{1});
        object.setBackgroundColor(0);
        this.dismissViews.add((View)object);
        object = freeLayout.addFreeView(new View(this.getContext()), -1, -1, (View)this.dialogLayout, new int[]{0});
        object.setBackgroundColor(0);
        this.dismissViews.add((View)object);
        object = this.dismissViews.iterator();
        while (object.hasNext()) {
            ((View)object.next()).setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!EasyProgressDialog.this.canceledOnTouchOutside) {
                        return;
                    }
                    EasyProgressDialog.this.dismiss();
                }
            });
        }
        this.setContentView((View)freeLayout);
    }

    public static EasyProgressDialog showSelf(Activity activity, Spanned spanned) {
        EasyProgressDialog.dismissSelf();
        EasyProgressDialog easyProgressDialog = dialog;
        if (easyProgressDialog == null || !easyProgressDialog.getContext().equals(activity)) {
            dialog = new EasyProgressDialog(activity);
        }
        if (!activity.isFinishing()) {
            dialog.setMessage(spanned);
            dialog.show();
        }
        return dialog;
    }

    public static EasyProgressDialog showSelf(Activity activity, String string2) {
        EasyProgressDialog.dismissSelf();
        EasyProgressDialog easyProgressDialog = dialog;
        if (easyProgressDialog == null || !easyProgressDialog.getContext().equals(activity)) {
            dialog = new EasyProgressDialog(activity);
        }
        if (!activity.isFinishing()) {
            dialog.setMessage(string2);
            dialog.show();
        }
        return dialog;
    }

    public void dismiss() {
        if (this.activity.isFinishing()) {
            return;
        }
        this.dialogLayout.startAnimation(this.getDismissAnimation());
        this.dialogLayout.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!EasyProgressDialog.this.activity.isFinishing()) {
                    EasyProgressDialog.this.progressBar.setVisibility(4);
                    EasyProgressDialog.super.dismiss();
                }
            }
        }, 250L);
    }

    public void setCanceledOnTouchOutside(boolean bl) {
        super.setCanceledOnTouchOutside(bl);
        this.canceledOnTouchOutside = bl;
    }

    public void setMessage(Spanned spanned) {
        if (TextUtils.isEmpty((CharSequence)spanned)) {
            this.progressText.setVisibility(8);
            this.progressText.setText(null);
        } else {
            this.progressText.setVisibility(0);
            this.progressText.setText((CharSequence)spanned);
        }
    }

    public void setMessage(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.progressText.setVisibility(8);
            this.progressText.setText(null);
        } else {
            this.progressText.setVisibility(0);
            this.progressText.setText(string2);
        }
    }

    public void show() {
        super.show();
        this.dialogLayout.startAnimation(this.getShowAnimation());
        this.progressBar.setVisibility(0);
    }

    public static class CustomProgressBar
    extends View {
        private int backgroundColor = -921103;
        private int color = Color.argb((int)255, (int)243, (int)122, (int)105);
        private int endAngle = 0;
        private int height;
        private boolean isAnimating = false;
        private Path oval;
        private Paint paint = new Paint();
        private int startAngle = 0;
        private int strokeWidth = 8;
        private int width;

        public CustomProgressBar(Context context) {
            super(context);
            this.oval = new Path();
            this.strokeWidth = MonitorUtils.resizeByMonitor(context, 8);
        }

        private void start() {
            int n;
            if (!this.isAnimating) {
                return;
            }
            this.startAngle = n = (this.startAngle + 29) % 360;
            this.endAngle = n + 200;
            this.postInvalidate();
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CustomProgressBar.this.start();
                }
            }, 35L);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            if (this.getWidth() != 0 && this.getHeight() != 0) {
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(this.backgroundColor);
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                this.paint.setStrokeWidth((float)this.strokeWidth);
                this.paint.setStyle(Paint.Style.FILL);
                int n = this.width;
                canvas.drawCircle((float)(n / 2), (float)(this.height / 2), (float)(n / 2), this.paint);
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(-11908534);
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                this.paint.setStrokeWidth(1.0f);
                this.paint.setStyle(Paint.Style.STROKE);
                n = this.width;
                canvas.drawCircle((float)(n / 2), (float)(this.height / 2), (float)(n / 2 - 1), this.paint);
                this.oval.reset();
                float f = this.width / 2 - this.strokeWidth;
                for (n = this.startAngle; n < this.endAngle; ++n) {
                    double d = (double)(n * 2) * Math.PI / 360.0;
                    if (n == this.startAngle) {
                        this.oval.moveTo((float)this.width / 2.0f + (float)Math.cos(d) * f, (float)(this.height / 2) + (float)Math.sin(d) * f);
                        continue;
                    }
                    this.oval.lineTo((float)this.width / 2.0f + (float)Math.cos(d) * f, (float)(this.height / 2) + (float)Math.sin(d) * f);
                }
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(this.color);
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                this.paint.setStrokeWidth((float)this.strokeWidth);
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawPath(this.oval, this.paint);
                return;
            }
            this.startAngle = 0;
            this.endAngle = 0;
        }

        protected void onSizeChanged(int n, int n2, int n3, int n4) {
            super.onSizeChanged(n, n2, n3, n4);
            this.width = n;
            this.height = n2;
            this.postInvalidate();
        }

        public void setProgressBackgroundColor(int n) {
            this.backgroundColor = n;
        }

        public void setProgressColor(int n) {
            this.color = n;
        }

        public void setVisibility(int n) {
            int n2 = this.getVisibility();
            super.setVisibility(n);
            if (n != 8 && n != 4) {
                if (n == 0) {
                    this.isAnimating = true;
                    if (n2 != 0) {
                        this.start();
                    }
                }
            } else {
                this.isAnimating = false;
                this.startAngle = 0;
                this.endAngle = 0;
            }
        }
    }
}

