/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import com.mapbox.android.core.connectivity.ConnectivityListener;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectivityReceiver
extends BroadcastReceiver {
    private int activationCounter;
    private Boolean connectedFlag;
    private CopyOnWriteArrayList<ConnectivityListener> connectivityListeners;
    private Context context;

    public ConnectivityReceiver(Context context) {
        this.context = context;
        this.connectivityListeners = new CopyOnWriteArrayList();
        this.connectedFlag = null;
    }

    private boolean getManagedConnectivity() {
        Boolean bl = this.connectedFlag;
        if (bl == null) {
            return ConnectivityReceiver.getSystemConnectivity(this.context);
        }
        return bl;
    }

    private static boolean getSystemConnectivity(Context context) {
        block3: {
            try {
                context = (ConnectivityManager)context.getSystemService("connectivity");
                if (context != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        boolean bl = context.getActiveNetworkInfo().isConnectedOrConnecting();
        return bl;
    }

    public static boolean isConnected(Context context) {
        return ConnectivityReceiver.getSystemConnectivity(context);
    }

    public void addConnectivityListener(ConnectivityListener connectivityListener) {
        if (!this.connectivityListeners.contains(connectivityListener)) {
            this.connectivityListeners.add(connectivityListener);
        }
    }

    public Boolean getConnectedFlag() {
        return this.connectedFlag;
    }

    public boolean isConnected() {
        return this.getManagedConnectivity();
    }

    public void onReceive(Context object, Intent intent) {
        boolean bl = this.getManagedConnectivity();
        object = this.connectivityListeners.iterator();
        while (object.hasNext()) {
            ((ConnectivityListener)object.next()).onConnectivityChanged(bl);
        }
    }

    public boolean removeConnectivityListener(ConnectivityListener connectivityListener) {
        return this.connectivityListeners.remove(connectivityListener);
    }

    public void removeConnectivityUpdates() {
        int n;
        this.activationCounter = n = this.activationCounter - 1;
        if (n == 0) {
            this.context.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public void requestConnectivityUpdates() {
        if (this.activationCounter == 0) {
            this.context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        ++this.activationCounter;
    }

    public void setConnectedFlag(Boolean bl) {
        this.connectedFlag = bl;
    }
}

