/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.mapbox.android.core.crashreporter.CrashReport;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CrashReportBuilder {
    private static final String OS_VERSION_FORMAT = "Android-%s";
    private static final String STACK_TRACE_ELEMENT_FORMAT = "%s.%s(%s:%d)";
    private static final String TAG = "CrashReportBuilder";
    private static final String THREAD_DETAILS_FORMAT = "tid:%s|name:%s|priority:%s";
    private final Set<String> allowedStacktracePrefixes;
    private final Context applicationContext;
    private final List<Throwable> causalChain = new ArrayList<Throwable>(4);
    private Map<String, String> customData = null;
    private boolean isSilent;
    private final String sdkIdentifier;
    private final String sdkVersion;
    private Thread uncaughtExceptionThread;

    private CrashReportBuilder(Context context, String string2, String string3, Set<String> set) {
        this.applicationContext = context;
        this.sdkIdentifier = string2;
        this.sdkVersion = string3;
        this.allowedStacktracePrefixes = set;
    }

    public static CrashReport fromJson(String object) throws IllegalArgumentException {
        try {
            object = new CrashReport((String)object);
            return object;
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException.toString());
        }
    }

    private static String getAppVersion(Context object) {
        try {
            String string2 = object.getPackageName();
            object = object.getPackageManager().getPackageInfo((String)string2, (int)0).versionName;
            return object;
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    private JSONArray getCustomData(Map<String, String> object) {
        if (object != null && !object.isEmpty()) {
            try {
                JSONArray jSONArray = new JSONArray();
                for (Map.Entry entry : object.entrySet()) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("name", entry.getKey());
                    jSONObject.put("value", entry.getValue());
                    jSONArray.put((Object)jSONObject);
                }
                return jSONArray;
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)"Failed to create JSON array for custom data", (Throwable)jSONException);
            }
        }
        return null;
    }

    static String getStackTraceHash(List<Throwable> object) {
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            for (StackTraceElement stackTraceElement : ((Throwable)object.next()).getStackTrace()) {
                stringBuilder.append(stackTraceElement.getClassName());
                stringBuilder.append(stackTraceElement.getMethodName());
            }
        }
        return Integer.toHexString(stringBuilder.toString().hashCode());
    }

    private boolean isAllowedStacktraceElement(StackTraceElement object) {
        object = ((StackTraceElement)object).getClassName();
        Iterator<String> iterator2 = this.allowedStacktracePrefixes.iterator();
        while (iterator2.hasNext()) {
            if (!((String)object).startsWith(iterator2.next())) continue;
            return true;
        }
        return ((String)object).startsWith(this.sdkIdentifier);
    }

    static CrashReportBuilder setup(Context context, String string2, String string3, Set<String> set) {
        return new CrashReportBuilder(context, string2, string3, set);
    }

    CrashReportBuilder addCausalChain(List<Throwable> list) {
        this.causalChain.addAll(list);
        return this;
    }

    CrashReportBuilder addExceptionThread(Thread thread2) {
        this.uncaughtExceptionThread = thread2;
        return this;
    }

    CrashReport build() {
        CrashReport crashReport = new CrashReport(new GregorianCalendar());
        crashReport.put("sdkIdentifier", this.sdkIdentifier);
        crashReport.put("sdkVersion", this.sdkVersion);
        crashReport.put("osVersion", String.format(OS_VERSION_FORMAT, Build.VERSION.RELEASE));
        crashReport.put("model", Build.MODEL);
        crashReport.put("device", Build.DEVICE);
        crashReport.put("isSilent", Boolean.toString(this.isSilent));
        crashReport.put("stackTraceHash", CrashReportBuilder.getStackTraceHash(this.causalChain));
        crashReport.put("stackTrace", this.getStackTrace(this.causalChain));
        Thread thread2 = this.uncaughtExceptionThread;
        if (thread2 != null) {
            crashReport.put("threadDetails", String.format(THREAD_DETAILS_FORMAT, thread2.getId(), this.uncaughtExceptionThread.getName(), this.uncaughtExceptionThread.getPriority()));
        }
        crashReport.put("appId", this.applicationContext.getPackageName());
        crashReport.put("appVersion", CrashReportBuilder.getAppVersion(this.applicationContext));
        crashReport.put("customData", this.getCustomData(this.customData));
        return crashReport;
    }

    String getStackTrace(List<Throwable> stackTraceElementArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Throwable throwable : stackTraceElementArray) {
            stackTraceElementArray = throwable.getStackTrace();
            if (stackTraceElementArray.length > 0 && this.isAllowedStacktraceElement(stackTraceElementArray[0]) && throwable.getMessage() != null) {
                stringBuilder.append(throwable.getMessage());
                stringBuilder.append('\n');
            } else {
                stringBuilder.append("***\n");
            }
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (this.isAllowedStacktraceElement(stackTraceElement)) {
                    stringBuilder.append(String.format(Locale.US, STACK_TRACE_ELEMENT_FORMAT, stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber()));
                    stringBuilder.append('\n');
                    continue;
                }
                stringBuilder.append("*\n");
            }
        }
        return stringBuilder.toString();
    }

    CrashReportBuilder isSilent(boolean bl) {
        this.isSilent = bl;
        return this;
    }

    CrashReportBuilder setCustomData(Map<String, String> map) {
        this.customData = map;
        return this;
    }
}

