/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.crashreporter;

import android.content.Context;
import com.mapbox.android.core.crashreporter.CrashReport;
import com.mapbox.android.core.crashreporter.CrashReportBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CrashReportFactory {
    private static final int DEFAULT_CRASH_CHAIN_DEPTH = 2;
    private static final int DEFAULT_NON_FATAL_ERROR_CHAIN_DEPTH = 1;
    private final Set<String> allowedStacktracePrefixes;
    private final Context applicationContext;
    private int crashChainDepth;
    private final String mapboxModuleVersion;
    private final String mapboxPackage;

    public CrashReportFactory(Context context, String string2, String string3, Set<String> set) {
        this.applicationContext = context;
        this.mapboxPackage = string2;
        this.mapboxModuleVersion = string3;
        this.allowedStacktracePrefixes = set;
        this.crashChainDepth = 2;
    }

    private boolean isMapboxStackTraceElement(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().startsWith(this.mapboxPackage);
    }

    public CrashReport createReportForCrash(Thread thread2, Throwable throwable) {
        return this.createReportForCrash(thread2, throwable, null);
    }

    public CrashReport createReportForCrash(Thread object, Throwable object2, Map<String, String> map) {
        object = this.isMapboxCrash((List<Throwable>)(object2 = this.getCausalChain((Throwable)object2, this.crashChainDepth))) ? CrashReportBuilder.setup(this.applicationContext, this.mapboxPackage, this.mapboxModuleVersion, this.allowedStacktracePrefixes).addExceptionThread((Thread)object).addCausalChain((List<Throwable>)object2).setCustomData(map).build() : null;
        return object;
    }

    public CrashReport createReportForNonFatal(Throwable throwable) {
        return this.createReportForNonFatal(throwable, null);
    }

    public CrashReport createReportForNonFatal(Throwable object, Map<String, String> map) {
        object = this.isMapboxCrash((List<Throwable>)(object = this.getCausalChain((Throwable)object, 1))) ? CrashReportBuilder.setup(this.applicationContext, this.mapboxPackage, this.mapboxModuleVersion, this.allowedStacktracePrefixes).isSilent(true).addCausalChain((List<Throwable>)object).setCustomData(map).build() : null;
        return object;
    }

    List<Throwable> getCausalChain(Throwable throwable, int n) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(4);
        int n2 = 0;
        while (throwable != null) {
            if (++n2 >= n) {
                arrayList.add(throwable);
            }
            throwable = throwable.getCause();
        }
        return Collections.unmodifiableList(arrayList);
    }

    boolean isMapboxCrash(List<Throwable> stackTraceElementArray) {
        Iterator<Throwable> iterator2 = stackTraceElementArray.iterator();
        block0: while (true) {
            boolean bl = iterator2.hasNext();
            int n = 0;
            if (!bl) break;
            stackTraceElementArray = iterator2.next().getStackTrace();
            int n2 = stackTraceElementArray.length;
            while (true) {
                if (n >= n2) continue block0;
                if (this.isMapboxStackTraceElement(stackTraceElementArray[n])) {
                    return true;
                }
                ++n;
            }
            break;
        }
        return false;
    }

    void setCrashChainDepth(int n) {
        this.crashChainDepth = n;
    }
}

