/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineImpl;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import java.util.Iterator;

class AndroidLocationEngineImpl
implements LocationEngineImpl<LocationListener> {
    private static final String TAG = "AndroidLocationEngine";
    String currentProvider = "passive";
    final LocationManager locationManager;

    AndroidLocationEngineImpl(Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    private String getBestProvider(int n) {
        String string2 = n != 3 ? this.locationManager.getBestProvider(AndroidLocationEngineImpl.getCriteria(n), true) : null;
        if (string2 == null) {
            string2 = "passive";
        }
        return string2;
    }

    static Criteria getCriteria(int n) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(AndroidLocationEngineImpl.priorityToAccuracy(n));
        criteria.setCostAllowed(true);
        criteria.setPowerRequirement(AndroidLocationEngineImpl.priorityToPowerRequirement(n));
        return criteria;
    }

    private static int priorityToAccuracy(int n) {
        if (n != 0 && n != 1) {
            return 2;
        }
        return 1;
    }

    private static int priorityToPowerRequirement(int n) {
        if (n != 0) {
            if (n != 1) {
                return 1;
            }
            return 2;
        }
        return 3;
    }

    @Override
    public LocationListener createListener(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        return new AndroidLocationEngineCallbackTransport(locationEngineCallback);
    }

    @Override
    public void getLastLocation(LocationEngineCallback<LocationEngineResult> locationEngineCallback) throws SecurityException {
        Location location = this.getLastLocationFor(this.currentProvider);
        if (location != null) {
            locationEngineCallback.onSuccess(LocationEngineResult.create(location));
            return;
        }
        Iterator iterator2 = this.locationManager.getAllProviders().iterator();
        while (iterator2.hasNext()) {
            location = this.getLastLocationFor((String)iterator2.next());
            if (location == null) continue;
            locationEngineCallback.onSuccess(LocationEngineResult.create(location));
            return;
        }
        locationEngineCallback.onFailure(new Exception("Last location unavailable"));
    }

    Location getLastLocationFor(String string2) throws SecurityException {
        try {
            string2 = this.locationManager.getLastKnownLocation(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)illegalArgumentException.toString());
            string2 = null;
        }
        return string2;
    }

    @Override
    public void removeLocationUpdates(PendingIntent pendingIntent) {
        if (pendingIntent != null) {
            this.locationManager.removeUpdates(pendingIntent);
        }
    }

    @Override
    public void removeLocationUpdates(LocationListener locationListener) {
        if (locationListener != null) {
            this.locationManager.removeUpdates(locationListener);
        }
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, PendingIntent pendingIntent) throws SecurityException {
        String string2;
        this.currentProvider = string2 = this.getBestProvider(locationEngineRequest.getPriority());
        this.locationManager.requestLocationUpdates(string2, locationEngineRequest.getInterval(), locationEngineRequest.getDisplacement(), pendingIntent);
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, LocationListener locationListener, Looper looper) throws SecurityException {
        String string2;
        this.currentProvider = string2 = this.getBestProvider(locationEngineRequest.getPriority());
        this.locationManager.requestLocationUpdates(string2, locationEngineRequest.getInterval(), locationEngineRequest.getDisplacement(), locationListener, looper);
    }

    static final class AndroidLocationEngineCallbackTransport
    implements LocationListener {
        private final LocationEngineCallback<LocationEngineResult> callback;

        AndroidLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
            this.callback = locationEngineCallback;
        }

        public void onLocationChanged(Location location) {
            this.callback.onSuccess(LocationEngineResult.create(location));
        }

        public void onProviderDisabled(String string2) {
            this.callback.onFailure(new Exception("Current provider disabled"));
        }

        public void onProviderEnabled(String string2) {
        }

        public void onStatusChanged(String string2, int n, Bundle bundle) {
        }
    }
}

