/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineImpl;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import java.util.Collections;
import java.util.List;

class GoogleLocationEngineImpl
implements LocationEngineImpl<LocationCallback> {
    private final FusedLocationProviderClient fusedLocationProviderClient;

    GoogleLocationEngineImpl(Context context) {
        this.fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)context);
    }

    GoogleLocationEngineImpl(FusedLocationProviderClient fusedLocationProviderClient) {
        this.fusedLocationProviderClient = fusedLocationProviderClient;
    }

    private static int toGMSLocationPriority(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return 105;
                }
                return 104;
            }
            return 102;
        }
        return 100;
    }

    private static LocationRequest toGMSLocationRequest(LocationEngineRequest locationEngineRequest) {
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(locationEngineRequest.getInterval());
        locationRequest.setFastestInterval(locationEngineRequest.getFastestInterval());
        locationRequest.setSmallestDisplacement(locationEngineRequest.getDisplacement());
        locationRequest.setMaxWaitTime(locationEngineRequest.getMaxWaitTime());
        locationRequest.setPriority(GoogleLocationEngineImpl.toGMSLocationPriority(locationEngineRequest.getPriority()));
        return locationRequest;
    }

    @Override
    public LocationCallback createListener(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        return new GoogleLocationEngineCallbackTransport(locationEngineCallback);
    }

    @Override
    public void getLastLocation(LocationEngineCallback<LocationEngineResult> object) throws SecurityException {
        object = new GoogleLastLocationEngineCallbackTransport((LocationEngineCallback<LocationEngineResult>)object);
        this.fusedLocationProviderClient.getLastLocation().addOnSuccessListener(object).addOnFailureListener((OnFailureListener)object);
    }

    @Override
    public void removeLocationUpdates(PendingIntent pendingIntent) {
        if (pendingIntent != null) {
            this.fusedLocationProviderClient.removeLocationUpdates(pendingIntent);
        }
    }

    @Override
    public void removeLocationUpdates(LocationCallback locationCallback) {
        if (locationCallback != null) {
            this.fusedLocationProviderClient.removeLocationUpdates(locationCallback);
        }
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, PendingIntent pendingIntent) throws SecurityException {
        this.fusedLocationProviderClient.requestLocationUpdates(GoogleLocationEngineImpl.toGMSLocationRequest(locationEngineRequest), pendingIntent);
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, LocationCallback locationCallback, Looper looper) throws SecurityException {
        this.fusedLocationProviderClient.requestLocationUpdates(GoogleLocationEngineImpl.toGMSLocationRequest(locationEngineRequest), locationCallback, looper);
    }

    static final class GoogleLastLocationEngineCallbackTransport
    implements OnSuccessListener<Location>,
    OnFailureListener {
        private final LocationEngineCallback<LocationEngineResult> callback;

        GoogleLastLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
            this.callback = locationEngineCallback;
        }

        @Override
        public void onFailure(Exception exception) {
            this.callback.onFailure(exception);
        }

        @Override
        public void onSuccess(Location object) {
            LocationEngineCallback<LocationEngineResult> locationEngineCallback = this.callback;
            object = object != null ? LocationEngineResult.create(object) : LocationEngineResult.create(Collections.<Location>emptyList());
            locationEngineCallback.onSuccess((LocationEngineResult)object);
        }
    }

    private static final class GoogleLocationEngineCallbackTransport
    extends LocationCallback {
        private final LocationEngineCallback<LocationEngineResult> callback;

        GoogleLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
            this.callback = locationEngineCallback;
        }

        public void onLocationResult(LocationResult object) {
            super.onLocationResult((LocationResult)object);
            object = object.getLocations();
            if (!object.isEmpty()) {
                this.callback.onSuccess(LocationEngineResult.create((List<Location>)object));
            } else {
                this.callback.onFailure(new Exception("Unavailable location"));
            }
        }
    }
}

