/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.content.Context;
import android.location.LocationListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.LocationCallback;
import com.mapbox.android.core.location.GoogleLocationEngineImpl;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineProxy;
import com.mapbox.android.core.location.MapboxFusedLocationEngineImpl;
import com.mapbox.android.core.location.Utils;

public final class LocationEngineProvider {
    private static final String GOOGLE_API_AVAILABILITY = "com.google.android.gms.common.GoogleApiAvailability";
    private static final String GOOGLE_LOCATION_SERVICES = "com.google.android.gms.location.LocationServices";

    private LocationEngineProvider() {
    }

    public static LocationEngine getBestLocationEngine(Context context) {
        boolean bl;
        Utils.checkNotNull(context, "context == null");
        boolean bl2 = bl = Utils.isOnClasspath(GOOGLE_LOCATION_SERVICES);
        if (Utils.isOnClasspath(GOOGLE_API_AVAILABILITY)) {
            boolean bl3 = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
            bl2 = bl & bl3;
        }
        return LocationEngineProvider.getLocationEngine(context, bl2);
    }

    @Deprecated
    public static LocationEngine getBestLocationEngine(Context context, boolean bl) {
        return LocationEngineProvider.getBestLocationEngine(context);
    }

    private static LocationEngine getLocationEngine(Context object, boolean bl) {
        object = bl ? new LocationEngineProxy<LocationCallback>(new GoogleLocationEngineImpl(object.getApplicationContext())) : new LocationEngineProxy<LocationListener>(new MapboxFusedLocationEngineImpl(object.getApplicationContext()));
        return object;
    }
}

