/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.app.PendingIntent;
import android.os.Looper;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineImpl;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.core.location.Utils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class LocationEngineProxy<T>
implements LocationEngine {
    private Map<LocationEngineCallback<LocationEngineResult>, T> listeners;
    private final LocationEngineImpl<T> locationEngineImpl;

    LocationEngineProxy(LocationEngineImpl<T> locationEngineImpl) {
        this.locationEngineImpl = locationEngineImpl;
    }

    @Override
    public void getLastLocation(LocationEngineCallback<LocationEngineResult> locationEngineCallback) throws SecurityException {
        Utils.checkNotNull(locationEngineCallback, "callback == null");
        this.locationEngineImpl.getLastLocation(locationEngineCallback);
    }

    T getListener(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        T t;
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap<LocationEngineCallback<LocationEngineResult>, T>();
        }
        T t2 = t = this.listeners.get(locationEngineCallback);
        if (t == null) {
            t2 = this.locationEngineImpl.createListener(locationEngineCallback);
        }
        this.listeners.put(locationEngineCallback, t2);
        return t2;
    }

    int getListenersCount() {
        Map<LocationEngineCallback<LocationEngineResult>, T> map = this.listeners;
        int n = map != null ? map.size() : 0;
        return n;
    }

    T removeListener(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        Map<LocationEngineCallback<LocationEngineResult>, T> map = this.listeners;
        locationEngineCallback = map != null ? map.remove(locationEngineCallback) : null;
        return (T)locationEngineCallback;
    }

    @Override
    public void removeLocationUpdates(PendingIntent pendingIntent) {
        this.locationEngineImpl.removeLocationUpdates(pendingIntent);
    }

    @Override
    public void removeLocationUpdates(LocationEngineCallback<LocationEngineResult> locationEngineCallback) {
        Utils.checkNotNull(locationEngineCallback, "callback == null");
        this.locationEngineImpl.removeLocationUpdates(this.removeListener(locationEngineCallback));
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, PendingIntent pendingIntent) throws SecurityException {
        Utils.checkNotNull(locationEngineRequest, "request == null");
        this.locationEngineImpl.requestLocationUpdates(locationEngineRequest, pendingIntent);
    }

    @Override
    public void requestLocationUpdates(LocationEngineRequest locationEngineRequest, LocationEngineCallback<LocationEngineResult> looper, Looper looper2) throws SecurityException {
        Utils.checkNotNull(locationEngineRequest, "request == null");
        Utils.checkNotNull(looper, "callback == null");
        LocationEngineImpl<T> locationEngineImpl = this.locationEngineImpl;
        T t = this.getListener((LocationEngineCallback<LocationEngineResult>)looper);
        looper = looper2;
        if (looper2 == null) {
            looper = Looper.getMainLooper();
        }
        locationEngineImpl.requestLocationUpdates(locationEngineRequest, t, looper);
    }
}

