/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

public class LocationEngineRequest {
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 1;
    public static final int PRIORITY_HIGH_ACCURACY = 0;
    public static final int PRIORITY_LOW_POWER = 2;
    public static final int PRIORITY_NO_POWER = 3;
    private final float displacement;
    private final long fastestInterval;
    private final long interval;
    private final long maxWaitTime;
    private final int priority;

    private LocationEngineRequest(Builder builder) {
        this.interval = builder.interval;
        this.priority = builder.priority;
        this.displacement = builder.displacement;
        this.maxWaitTime = builder.maxWaitTime;
        this.fastestInterval = builder.fastestInterval;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (LocationEngineRequest)object;
            if (this.interval != ((LocationEngineRequest)object).interval) {
                return false;
            }
            if (this.priority != ((LocationEngineRequest)object).priority) {
                return false;
            }
            if (Float.compare(((LocationEngineRequest)object).displacement, this.displacement) != 0) {
                return false;
            }
            if (this.maxWaitTime != ((LocationEngineRequest)object).maxWaitTime) {
                return false;
            }
            if (this.fastestInterval != ((LocationEngineRequest)object).fastestInterval) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public float getDisplacement() {
        return this.displacement;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public int getPriority() {
        return this.priority;
    }

    public int hashCode() {
        long l = this.interval;
        int n = (int)(l ^ l >>> 32);
        int n2 = this.priority;
        float f = this.displacement;
        int n3 = f != 0.0f ? Float.floatToIntBits(f) : 0;
        l = this.maxWaitTime;
        int n4 = (int)(l ^ l >>> 32);
        l = this.fastestInterval;
        return (((n * 31 + n2) * 31 + n3) * 31 + n4) * 31 + (int)(l ^ l >>> 32);
    }

    public static final class Builder {
        private float displacement;
        private long fastestInterval;
        private final long interval;
        private long maxWaitTime;
        private int priority;

        public Builder(long l) {
            this.interval = l;
            this.priority = 0;
            this.displacement = 0.0f;
            this.maxWaitTime = 0L;
            this.fastestInterval = 0L;
        }

        public LocationEngineRequest build() {
            return new LocationEngineRequest(this);
        }

        public Builder setDisplacement(float f) {
            this.displacement = f;
            return this;
        }

        public Builder setFastestInterval(long l) {
            this.fastestInterval = l;
            return this;
        }

        public Builder setMaxWaitTime(long l) {
            this.maxWaitTime = l;
            return this;
        }

        public Builder setPriority(int n) {
            this.priority = n;
            return this;
        }
    }
}

