/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.location;

import android.location.Location;
import java.util.Objects;

final class Utils {
    private static final int ACCURACY_THRESHOLD_METERS = 200;
    private static final int TWO_MINUTES = 120000;

    private Utils() {
    }

    static <T> T checkNotNull(T t, String string2) {
        Objects.requireNonNull(t, string2);
        return t;
    }

    static boolean isBetterLocation(Location location, Location location2) {
        if (location2 == null) {
            return true;
        }
        long l = location.getTime() - location2.getTime();
        boolean bl = l > 120000L;
        boolean bl2 = l < -120000L;
        boolean bl3 = l > 0L;
        if (bl) {
            return true;
        }
        if (bl2) {
            return false;
        }
        int n = (int)(location.getAccuracy() - location2.getAccuracy());
        bl = n > 0;
        bl2 = n < 0;
        n = n > 200 ? 1 : 0;
        boolean bl4 = Utils.isSameProvider(location.getProvider(), location2.getProvider());
        if (bl2) {
            return true;
        }
        if (bl3 && !bl) {
            return true;
        }
        return bl3 && n == 0 && bl4;
    }

    static boolean isOnClasspath(String string2) {
        boolean bl;
        try {
            Class.forName(string2);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private static boolean isSameProvider(String string2, String string3) {
        if (string2 == null) {
            boolean bl = string3 == null;
            return bl;
        }
        return string2.equals(string3);
    }
}

