/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.core.metrics;

import android.os.SystemClock;
import com.mapbox.android.core.metrics.Metrics;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCompositeMetrics {
    private final long maxLength;
    private final Map<String, Deque<Metrics>> metricsMap = new ConcurrentHashMap<String, Deque<Metrics>>();

    public AbstractCompositeMetrics(long l) {
        this.maxLength = l;
    }

    private Deque<Metrics> getOrCreateMetrics(String string2) {
        Deque<Metrics> deque;
        Deque<Metrics> deque2 = deque = this.metricsMap.get(string2);
        if (deque == null) {
            deque2 = new ArrayDeque<Metrics>();
            this.metricsMap.put(string2, deque2);
        }
        if (deque2.isEmpty()) {
            long l = SystemClock.uptimeMillis();
            deque2.add(this.nextMetrics(l, this.maxLength + l));
        }
        return deque2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(String object, long l) {
        long l2 = SystemClock.uptimeMillis();
        synchronized (this) {
            object = this.getOrCreateMetrics(((String)object).trim());
            if (l2 >= ((Metrics)object.getLast()).getEnd()) {
                object.add(this.nextMetrics(l2, this.maxLength + l2));
            }
            object = (Metrics)object.getLast();
        }
        object.add(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Metrics getMetrics(String object) {
        object = this.metricsMap.get(((String)object).trim());
        synchronized (this) {
            if (object == null) return null;
            try {
                if (object.isEmpty()) return null;
                return (Metrics)object.pop();
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    protected abstract Metrics nextMetrics(long var1, long var3);
}

