/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.BaseGesture;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PermittedActionsGuard;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import com.mapbox.android.gestures.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class MultiFingerGesture<L>
extends BaseGesture<L> {
    private static final int DEFAULT_REQUIRED_FINGERS_COUNT = 2;
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private DisplayMetrics displayMetrics;
    private final float edgeSlop;
    private PointF focalPoint;
    private final PermittedActionsGuard permittedActionsGuard = new PermittedActionsGuard();
    final List<Integer> pointerIdList = new ArrayList<Integer>();
    final HashMap<PointerDistancePair, MultiFingerDistancesObject> pointersDistanceMap = new HashMap();
    private float spanThreshold;

    public MultiFingerGesture(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
        this.focalPoint = new PointF();
        this.edgeSlop = ViewConfiguration.get((Context)context).getScaledEdgeSlop();
        this.queryDisplayMetrics();
    }

    private void calculateDistances() {
        this.pointersDistanceMap.clear();
        int n = 0;
        while (n < this.pointerIdList.size() - 1) {
            int n2;
            for (int i = n2 = n + 1; i < this.pointerIdList.size(); ++i) {
                int n3 = this.pointerIdList.get(n);
                int n4 = this.pointerIdList.get(i);
                float f = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(n3));
                float f2 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(n3));
                float f3 = this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(n4));
                float f4 = this.getPreviousEvent().getY(this.getPreviousEvent().findPointerIndex(n4));
                float f5 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(n3));
                float f6 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(n3));
                float f7 = this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(n4));
                float f8 = this.getCurrentEvent().getY(this.getCurrentEvent().findPointerIndex(n4));
                this.pointersDistanceMap.put(new PointerDistancePair(n3, n4), new MultiFingerDistancesObject(f3 - f, f4 - f2, f7 - f5, f8 - f6));
            }
            n = n2;
        }
    }

    private boolean checkSpanBelowThreshold() {
        Iterator<MultiFingerDistancesObject> iterator2 = this.pointersDistanceMap.values().iterator();
        while (iterator2.hasNext()) {
            if (!(iterator2.next().getCurrFingersDiffXY() < this.spanThreshold)) continue;
            return true;
        }
        return false;
    }

    private boolean isMissingPointers(MotionEvent motionEvent) {
        block1: {
            boolean bl;
            Iterator<Integer> iterator2 = this.pointerIdList.iterator();
            do {
                boolean bl2 = iterator2.hasNext();
                bl = false;
                if (!bl2) break block1;
                if (motionEvent.findPointerIndex(iterator2.next().intValue()) == -1) continue;
                bl = true;
            } while (bl);
            return true;
        }
        return false;
    }

    private void queryDisplayMetrics() {
        if (this.windowManager != null) {
            this.displayMetrics = new DisplayMetrics();
            Display display = this.windowManager.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealMetrics(this.displayMetrics);
            } else {
                display.getMetrics(this.displayMetrics);
            }
        } else {
            this.displayMetrics = this.context.getResources().getDisplayMetrics();
        }
    }

    private void updatePointerList(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n != 0 && n != 5) {
            if (n == 1 || n == 6) {
                this.pointerIdList.remove((Object)motionEvent.getPointerId(motionEvent.getActionIndex()));
            }
        } else {
            this.pointerIdList.add(motionEvent.getPointerId(motionEvent.getActionIndex()));
        }
    }

    private boolean verifyPointers(int n, int n2) {
        boolean bl = n != n2 && n >= 0 && n2 >= 0 && n < this.getPointersCount() && n2 < this.getPointersCount();
        return bl;
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.queryDisplayMetrics();
        }
        boolean bl = this.permittedActionsGuard.isMissingActions(n, motionEvent.getPointerCount(), this.pointerIdList.size()) || n == 2 && this.isMissingPointers(motionEvent);
        if (bl) {
            ProgressiveGesture progressiveGesture;
            if (this instanceof ProgressiveGesture && (progressiveGesture = (ProgressiveGesture)this).isInProgress()) {
                progressiveGesture.gestureStopped();
            }
            this.pointerIdList.clear();
            this.pointersDistanceMap.clear();
        }
        if (!bl || n == 0) {
            this.updatePointerList(motionEvent);
        }
        this.focalPoint = Utils.determineFocalPoint(motionEvent);
        if (bl) {
            Log.w((String)"MultiFingerGesture", (String)"Some MotionEvents were not passed to the library or events from different view trees are merged.");
            return false;
        }
        if (n == 2 && this.pointerIdList.size() >= this.getRequiredPointersCount() && this.checkPressure()) {
            this.calculateDistances();
            if (!this.isSloppyGesture()) {
                return this.analyzeMovement();
            }
        }
        return false;
    }

    protected boolean analyzeMovement() {
        return false;
    }

    @Override
    protected boolean canExecute(int n) {
        boolean bl = super.canExecute(n) && !this.isSloppyGesture();
        return bl;
    }

    boolean checkPressure() {
        boolean bl = this.getCurrentEvent().getPressure() / this.getPreviousEvent().getPressure() > 0.67f;
        return bl;
    }

    public float getCurrentSpan(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getCurrFingersDiffXY();
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    public float getCurrentSpanX(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return Math.abs(this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getCurrFingersDiffX());
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    public float getCurrentSpanY(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return Math.abs(this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getCurrFingersDiffY());
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    public PointF getFocalPoint() {
        return this.focalPoint;
    }

    public int getPointersCount() {
        return this.pointerIdList.size();
    }

    public float getPreviousSpan(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getPrevFingersDiffXY();
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    public float getPreviousSpanX(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return Math.abs(this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getPrevFingersDiffX());
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    public float getPreviousSpanY(int n, int n2) {
        if (this.verifyPointers(n, n2)) {
            return Math.abs(this.pointersDistanceMap.get((Object)new PointerDistancePair(this.pointerIdList.get(n), this.pointerIdList.get(n2))).getPrevFingersDiffY());
        }
        throw new NoSuchElementException("There is no such pair of pointers!");
    }

    protected int getRequiredPointersCount() {
        return 2;
    }

    public float getSpanThreshold() {
        return this.spanThreshold;
    }

    protected boolean isSloppyGesture() {
        float f = this.displayMetrics.widthPixels;
        float f2 = this.edgeSlop;
        float f3 = this.displayMetrics.heightPixels;
        float f4 = this.edgeSlop;
        for (int n : this.pointerIdList) {
            n = this.getCurrentEvent().findPointerIndex(n);
            float f5 = Utils.getRawX(this.getCurrentEvent(), n);
            float f6 = Utils.getRawY(this.getCurrentEvent(), n);
            n = !(f5 < f4 || f6 < f4 || f5 > f - f2 || f6 > f3 - f4) ? 0 : 1;
            if (n == 0) continue;
            return true;
        }
        return this.checkSpanBelowThreshold();
    }

    protected void reset() {
    }

    public void setSpanThreshold(float f) {
        this.spanThreshold = f;
    }

    public void setSpanThresholdResource(int n) {
        this.setSpanThreshold(this.context.getResources().getDimension(n));
    }
}

