/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.MultiFingerGesture;
import com.mapbox.android.gestures.PointerDistancePair;
import java.util.HashMap;
import java.util.Iterator;

public class MultiFingerTapGestureDetector
extends MultiFingerGesture<OnMultiFingerTapGestureListener> {
    private boolean invalidMovement;
    private int lastPointersDownCount;
    private float multiFingerTapMovementThreshold;
    private long multiFingerTapTimeThreshold;
    private boolean pointerLifted;

    public MultiFingerTapGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        super.analyzeEvent(motionEvent);
        int n = motionEvent.getActionMasked();
        boolean bl = false;
        if (n != 1) {
            if (n != 2) {
                if (n != 5) {
                    if (n == 6) {
                        this.pointerLifted = true;
                    }
                } else {
                    if (this.pointerLifted) {
                        this.invalidMovement = true;
                    }
                    this.lastPointersDownCount = this.pointerIdList.size();
                }
            } else if (!this.invalidMovement) {
                this.invalidMovement = this.exceededMovementThreshold(this.pointersDistanceMap);
            }
            return false;
        }
        if (this.canExecute(4)) {
            bl = ((OnMultiFingerTapGestureListener)this.listener).onMultiFingerTap(this, this.lastPointersDownCount);
        }
        this.reset();
        return bl;
    }

    @Override
    protected boolean canExecute(int n) {
        int n2 = this.lastPointersDownCount;
        boolean bl = true;
        if (n2 <= 1 || this.invalidMovement || this.getGestureDuration() >= this.multiFingerTapTimeThreshold || !super.canExecute(n)) {
            bl = false;
        }
        return bl;
    }

    boolean exceededMovementThreshold(HashMap<PointerDistancePair, MultiFingerDistancesObject> object) {
        block2: {
            boolean bl;
            Iterator<MultiFingerDistancesObject> iterator2 = ((HashMap)object).values().iterator();
            do {
                boolean bl2 = iterator2.hasNext();
                bl = false;
                if (!bl2) break block2;
                object = iterator2.next();
                float f = Math.abs(((MultiFingerDistancesObject)object).getCurrFingersDiffX() - ((MultiFingerDistancesObject)object).getPrevFingersDiffX());
                float f2 = Math.abs(((MultiFingerDistancesObject)object).getCurrFingersDiffY() - ((MultiFingerDistancesObject)object).getPrevFingersDiffY());
                float f3 = this.multiFingerTapMovementThreshold;
                if (f > f3 || f2 > f3) {
                    bl = true;
                }
                this.invalidMovement = bl;
            } while (!bl);
            return true;
        }
        return false;
    }

    public float getMultiFingerTapMovementThreshold() {
        return this.multiFingerTapMovementThreshold;
    }

    public long getMultiFingerTapTimeThreshold() {
        return this.multiFingerTapTimeThreshold;
    }

    @Override
    protected void reset() {
        super.reset();
        this.lastPointersDownCount = 0;
        this.invalidMovement = false;
        this.pointerLifted = false;
    }

    public void setMultiFingerTapMovementThreshold(float f) {
        this.multiFingerTapMovementThreshold = f;
    }

    public void setMultiFingerTapMovementThresholdResource(int n) {
        this.setMultiFingerTapMovementThreshold(this.context.getResources().getDimension(n));
    }

    public void setMultiFingerTapTimeThreshold(long l) {
        this.multiFingerTapTimeThreshold = l;
    }

    public static interface OnMultiFingerTapGestureListener {
        public boolean onMultiFingerTap(MultiFingerTapGestureDetector var1, int var2);
    }
}

