/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerGesture;
import java.util.Set;

public abstract class ProgressiveGesture<L>
extends MultiFingerGesture<L> {
    private final Set<Integer> handledTypes = this.provideHandledTypes();
    private boolean interrupted;
    private boolean isInProgress;
    VelocityTracker velocityTracker;
    float velocityX;
    float velocityY;

    public ProgressiveGesture(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        VelocityTracker velocityTracker;
        int n = motionEvent.getActionMasked();
        if (n == 0 || n == 5 || n == 6 || n == 3) {
            this.reset();
        }
        if (this.interrupted) {
            this.interrupted = false;
            this.reset();
            this.gestureStopped();
        }
        if ((velocityTracker = this.velocityTracker) != null) {
            velocityTracker.addMovement(this.getCurrentEvent());
        }
        boolean bl = super.analyzeEvent(motionEvent);
        if (n != 1 && n != 6) {
            if (n == 3 && this.isInProgress) {
                this.gestureStopped();
                return true;
            }
        } else if (this.pointerIdList.size() < this.getRequiredPointersCount() && this.isInProgress) {
            this.gestureStopped();
            return true;
        }
        return bl;
    }

    protected void gestureStarted() {
        this.isInProgress = true;
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    protected void gestureStopped() {
        this.isInProgress = false;
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.computeCurrentVelocity(1000);
            this.velocityX = this.velocityTracker.getXVelocity();
            this.velocityY = this.velocityTracker.getYVelocity();
            this.velocityTracker.recycle();
            this.velocityTracker = null;
        }
        this.reset();
    }

    Set<Integer> getHandledTypes() {
        return this.handledTypes;
    }

    public void interrupt() {
        if (this.isInProgress()) {
            this.interrupted = true;
        }
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    protected abstract Set<Integer> provideHandledTypes();

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl) {
            this.interrupt();
        }
    }
}

