/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

public class RotateGestureDetector
extends ProgressiveGesture<OnRotateGestureListener> {
    private static final Set<Integer> handledTypes;
    private float angleThreshold;
    float deltaSinceLast;
    float deltaSinceStart;

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        handledTypes = hashSet;
        hashSet.add(2);
    }

    public RotateGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    @Override
    protected boolean analyzeMovement() {
        float f;
        super.analyzeMovement();
        this.deltaSinceLast = f = this.getRotationDegreesSinceLast();
        this.deltaSinceStart += f;
        if (this.isInProgress() && this.deltaSinceLast != 0.0f) {
            return ((OnRotateGestureListener)this.listener).onRotate(this, this.deltaSinceLast, this.deltaSinceStart);
        }
        if (this.canExecute(2) && ((OnRotateGestureListener)this.listener).onRotateBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    float calculateAngularVelocityVector(float f, float f2) {
        f = f2 = Math.abs((float)((double)(this.getFocalPoint().x * f2 + this.getFocalPoint().y * f) / (Math.pow(this.getFocalPoint().x, 2.0) + Math.pow(this.getFocalPoint().y, 2.0))));
        if (this.deltaSinceLast < 0.0f) {
            f = -f2;
        }
        return f;
    }

    @Override
    protected boolean canExecute(int n) {
        boolean bl = Math.abs(this.deltaSinceStart) >= this.angleThreshold && super.canExecute(n);
        return bl;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        if (this.deltaSinceLast == 0.0f) {
            this.velocityX = 0.0f;
            this.velocityY = 0.0f;
        }
        float f = this.calculateAngularVelocityVector(this.velocityX, this.velocityY);
        ((OnRotateGestureListener)this.listener).onRotateEnd(this, this.velocityX, this.velocityY, f);
    }

    public float getAngleThreshold() {
        return this.angleThreshold;
    }

    public float getDeltaSinceLast() {
        return this.deltaSinceLast;
    }

    public float getDeltaSinceStart() {
        return this.deltaSinceStart;
    }

    float getRotationDegreesSinceLast() {
        MultiFingerDistancesObject multiFingerDistancesObject = (MultiFingerDistancesObject)this.pointersDistanceMap.get((Object)new PointerDistancePair((Integer)this.pointerIdList.get(0), (Integer)this.pointerIdList.get(1)));
        return (float)Math.toDegrees(Math.atan2(multiFingerDistancesObject.getPrevFingersDiffY(), multiFingerDistancesObject.getPrevFingersDiffX()) - Math.atan2(multiFingerDistancesObject.getCurrFingersDiffY(), multiFingerDistancesObject.getCurrFingersDiffX()));
    }

    @Override
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaSinceStart = 0.0f;
    }

    public void setAngleThreshold(float f) {
        this.angleThreshold = f;
    }

    public static interface OnRotateGestureListener {
        public boolean onRotate(RotateGestureDetector var1, float var2, float var3);

        public boolean onRotateBegin(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1, float var2, float var3, float var4);
    }

    public static class SimpleOnRotateGestureListener
    implements OnRotateGestureListener {
        @Override
        public boolean onRotate(RotateGestureDetector rotateGestureDetector, float f, float f2) {
            return true;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector rotateGestureDetector) {
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector rotateGestureDetector, float f, float f2, float f3) {
        }
    }
}

