/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MultiFingerDistancesObject;
import com.mapbox.android.gestures.PointerDistancePair;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SidewaysShoveGestureDetector
extends ProgressiveGesture<OnSidewaysShoveGestureListener> {
    private static final Set<Integer> handledTypes;
    float deltaPixelSinceLast;
    float deltaPixelsSinceStart;
    private float maxShoveAngle;
    private float pixelDeltaThreshold;

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        handledTypes = hashSet;
        hashSet.add(14);
    }

    public SidewaysShoveGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
    }

    @Override
    protected boolean analyzeMovement() {
        float f;
        super.analyzeMovement();
        this.deltaPixelSinceLast = f = this.calculateDeltaPixelsSinceLast();
        this.deltaPixelsSinceStart += f;
        if (this.isInProgress() && this.deltaPixelSinceLast != 0.0f) {
            return ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShove(this, this.deltaPixelSinceLast, this.deltaPixelsSinceStart);
        }
        if (this.canExecute(14) && ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShoveBegin(this)) {
            this.gestureStarted();
            return true;
        }
        return false;
    }

    float calculateDeltaPixelsSinceLast() {
        float f = (this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue())) + this.getPreviousEvent().getX(this.getPreviousEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()))) / 2.0f;
        return (this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(0)).intValue())) + this.getCurrentEvent().getX(this.getCurrentEvent().findPointerIndex(((Integer)this.pointerIdList.get(1)).intValue()))) / 2.0f - f;
    }

    @Override
    protected boolean canExecute(int n) {
        boolean bl = Math.abs(this.deltaPixelsSinceStart) >= this.pixelDeltaThreshold && super.canExecute(n);
        return bl;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((OnSidewaysShoveGestureListener)this.listener).onSidewaysShoveEnd(this, this.velocityX, this.velocityY);
    }

    public float getDeltaPixelSinceLast() {
        return this.deltaPixelSinceLast;
    }

    public float getDeltaPixelsSinceStart() {
        return this.deltaPixelsSinceStart;
    }

    public float getMaxShoveAngle() {
        return this.maxShoveAngle;
    }

    public float getPixelDeltaThreshold() {
        return this.pixelDeltaThreshold;
    }

    boolean isAngleAcceptable() {
        HashMap hashMap = this.pointersDistanceMap;
        Object object = this.pointerIdList;
        boolean bl = false;
        if (Math.abs(Math.toDegrees(Math.abs(Math.atan2(((MultiFingerDistancesObject)(object = (MultiFingerDistancesObject)hashMap.get((Object)new PointerDistancePair((Integer)object.get(0), (Integer)this.pointerIdList.get(1))))).getCurrFingersDiffY(), ((MultiFingerDistancesObject)object).getCurrFingersDiffX()))) - 90.0) <= (double)this.maxShoveAngle) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected boolean isSloppyGesture() {
        boolean bl = super.isSloppyGesture() || !this.isAngleAcceptable();
        return bl;
    }

    @Override
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected void reset() {
        super.reset();
        this.deltaPixelsSinceStart = 0.0f;
    }

    public void setMaxShoveAngle(float f) {
        this.maxShoveAngle = f;
    }

    public void setPixelDeltaThreshold(float f) {
        this.pixelDeltaThreshold = f;
    }

    public void setPixelDeltaThresholdResource(int n) {
        this.setPixelDeltaThreshold(this.context.getResources().getDimension(n));
    }

    public static interface OnSidewaysShoveGestureListener {
        public boolean onSidewaysShove(SidewaysShoveGestureDetector var1, float var2, float var3);

        public boolean onSidewaysShoveBegin(SidewaysShoveGestureDetector var1);

        public void onSidewaysShoveEnd(SidewaysShoveGestureDetector var1, float var2, float var3);
    }

    public static class SimpleOnSidewaysShoveGestureListener
    implements OnSidewaysShoveGestureListener {
        @Override
        public boolean onSidewaysShove(SidewaysShoveGestureDetector sidewaysShoveGestureDetector, float f, float f2) {
            return false;
        }

        @Override
        public boolean onSidewaysShoveBegin(SidewaysShoveGestureDetector sidewaysShoveGestureDetector) {
            return true;
        }

        @Override
        public void onSidewaysShoveEnd(SidewaysShoveGestureDetector sidewaysShoveGestureDetector, float f, float f2) {
        }
    }
}

