/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.core.view.GestureDetectorCompat;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.ProgressiveGesture;
import java.util.HashSet;
import java.util.Set;

public class StandardScaleGestureDetector
extends ProgressiveGesture<StandardOnScaleGestureListener> {
    private static final float QUICK_SCALE_MULTIPLIER = 0.5f;
    private static final Set<Integer> handledTypes;
    private float currentSpan;
    private float currentSpanX;
    private float currentSpanY;
    private final GestureDetectorCompat innerGestureDetector;
    private boolean isScalingOut;
    private float previousSpan;
    private float previousSpanX;
    private float previousSpanY;
    private boolean quickScale;
    private PointF quickScaleFocalPoint;
    private float scaleFactor;
    private float spanDeltaSinceStart;
    private float spanSinceStartThreshold;
    private float startSpan;
    private float startSpanX;
    private float startSpanY;

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        handledTypes = hashSet;
        hashSet.add(1);
        hashSet.add(15);
    }

    public StandardScaleGestureDetector(Context context, AndroidGesturesManager androidGesturesManager) {
        super(context, androidGesturesManager);
        this.innerGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTapEvent(MotionEvent motionEvent) {
                if (motionEvent.getActionMasked() == 0) {
                    StandardScaleGestureDetector.access$002(StandardScaleGestureDetector.this, true);
                    StandardScaleGestureDetector.access$102(StandardScaleGestureDetector.this, new PointF(motionEvent.getX(), motionEvent.getY()));
                }
                return true;
            }
        });
    }

    static /* synthetic */ boolean access$002(StandardScaleGestureDetector standardScaleGestureDetector, boolean bl) {
        standardScaleGestureDetector.quickScale = bl;
        return bl;
    }

    static /* synthetic */ PointF access$102(StandardScaleGestureDetector standardScaleGestureDetector, PointF pointF) {
        standardScaleGestureDetector.quickScaleFocalPoint = pointF;
        return pointF;
    }

    private float calculateScaleFactor() {
        boolean bl = this.quickScale;
        float f = 1.0f;
        if (bl) {
            boolean bl2 = this.getCurrentEvent().getY() < this.quickScaleFocalPoint.y && this.currentSpan < this.previousSpan || this.getCurrentEvent().getY() > this.quickScaleFocalPoint.y && this.currentSpan > this.previousSpan;
            float f2 = Math.abs(1.0f - this.currentSpan / this.previousSpan) * 0.5f;
            if (!(this.previousSpan <= 0.0f)) {
                f = bl2 ? 1.0f + f2 : 1.0f - f2;
            }
            return f;
        }
        float f3 = this.previousSpan;
        if (f3 > 0.0f) {
            f = this.currentSpan / f3;
        }
        return f;
    }

    @Override
    protected boolean analyzeEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (this.quickScale) {
            if (n != 5 && n != 3) {
                if (!this.isInProgress() && n == 1) {
                    this.quickScale = false;
                }
            } else if (this.isInProgress()) {
                this.interrupt();
            } else {
                this.quickScale = false;
            }
        }
        boolean bl = super.analyzeEvent(motionEvent);
        return this.innerGestureDetector.onTouchEvent(motionEvent) | bl;
    }

    @Override
    protected boolean analyzeMovement() {
        float f;
        float f2;
        int n;
        super.analyzeMovement();
        boolean bl = this.isInProgress();
        boolean bl2 = false;
        int n2 = 1;
        if (bl && this.quickScale && this.getPointersCount() > 1) {
            this.gestureStopped();
            return false;
        }
        PointF pointF = this.quickScale ? this.quickScaleFocalPoint : this.getFocalPoint();
        this.currentSpanX = 0.0f;
        this.currentSpanY = 0.0f;
        for (n = 0; n < this.getPointersCount(); ++n) {
            this.currentSpanX += Math.abs(this.getCurrentEvent().getX(n) - pointF.x);
            this.currentSpanY += Math.abs(this.getCurrentEvent().getY(n) - pointF.y);
        }
        this.currentSpanX = f2 = this.currentSpanX * 2.0f;
        this.currentSpanY = f = this.currentSpanY * 2.0f;
        this.currentSpan = this.quickScale ? f : (float)Math.hypot(f2, f);
        if (this.startSpan == 0.0f) {
            this.startSpan = this.currentSpan;
            this.startSpanX = this.currentSpanX;
            this.startSpanY = this.currentSpanY;
        }
        this.spanDeltaSinceStart = Math.abs(this.startSpan - this.currentSpan);
        this.scaleFactor = f = this.calculateScaleFactor();
        bl = f < 1.0f;
        this.isScalingOut = bl;
        if (this.isInProgress() && this.currentSpan > 0.0f) {
            bl = ((StandardOnScaleGestureListener)this.listener).onScale(this);
        } else {
            n = n2;
            if (this.quickScale) {
                n = 15;
            }
            bl = bl2;
            if (this.canExecute(n)) {
                bl = bl2;
                if (this.spanDeltaSinceStart >= this.spanSinceStartThreshold) {
                    bl = bl2 = ((StandardOnScaleGestureListener)this.listener).onScaleBegin(this);
                    if (bl2) {
                        this.gestureStarted();
                        bl = bl2;
                    }
                }
            }
        }
        this.previousSpan = this.currentSpan;
        this.previousSpanX = this.currentSpanX;
        this.previousSpanY = this.currentSpanY;
        return bl;
    }

    @Override
    protected void gestureStopped() {
        super.gestureStopped();
        ((StandardOnScaleGestureListener)this.listener).onScaleEnd(this, this.velocityX, this.velocityY);
        this.quickScale = false;
    }

    public float getCurrentSpan() {
        return this.currentSpan;
    }

    public float getCurrentSpanX() {
        return this.currentSpanX;
    }

    public float getCurrentSpanY() {
        return this.currentSpanY;
    }

    public float getPreviousSpan() {
        return this.previousSpan;
    }

    public float getPreviousSpanX() {
        return this.previousSpanX;
    }

    public float getPreviousSpanY() {
        return this.previousSpanY;
    }

    @Override
    protected int getRequiredPointersCount() {
        int n;
        boolean bl = this.isInProgress();
        int n2 = n = 1;
        if (bl) {
            n2 = this.quickScale ? n : 2;
        }
        return n2;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public float getSpanSinceStartThreshold() {
        return this.spanSinceStartThreshold;
    }

    public float getStartSpan() {
        return this.startSpan;
    }

    public float getStartSpanX() {
        return this.startSpanX;
    }

    public float getStartSpanY() {
        return this.startSpanY;
    }

    public boolean isScalingOut() {
        return this.isScalingOut;
    }

    @Override
    protected boolean isSloppyGesture() {
        boolean bl = super.isSloppyGesture() || !this.quickScale && this.getPointersCount() < 2;
        return bl;
    }

    @Override
    protected Set<Integer> provideHandledTypes() {
        return handledTypes;
    }

    @Override
    protected void reset() {
        super.reset();
        this.startSpan = 0.0f;
        this.spanDeltaSinceStart = 0.0f;
        this.currentSpan = 0.0f;
        this.previousSpan = 0.0f;
        this.scaleFactor = 1.0f;
    }

    public void setSpanSinceStartThreshold(float f) {
        this.spanSinceStartThreshold = f;
    }

    public void setSpanSinceStartThresholdResource(int n) {
        this.setSpanSinceStartThreshold(this.context.getResources().getDimension(n));
    }

    public static class SimpleStandardOnScaleGestureListener
    implements StandardOnScaleGestureListener {
        @Override
        public boolean onScale(StandardScaleGestureDetector standardScaleGestureDetector) {
            return false;
        }

        @Override
        public boolean onScaleBegin(StandardScaleGestureDetector standardScaleGestureDetector) {
            return true;
        }

        @Override
        public void onScaleEnd(StandardScaleGestureDetector standardScaleGestureDetector, float f, float f2) {
        }
    }

    public static interface StandardOnScaleGestureListener {
        public boolean onScale(StandardScaleGestureDetector var1);

        public boolean onScaleBegin(StandardScaleGestureDetector var1);

        public void onScaleEnd(StandardScaleGestureDetector var1, float var2, float var3);
    }
}

