/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.gestures;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;

public class Utils {
    public static PointF determineFocalPoint(MotionEvent motionEvent) {
        int n = motionEvent.getPointerCount();
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += motionEvent.getX(i);
            f2 += motionEvent.getY(i);
        }
        float f3 = n;
        return new PointF(f / f3, f2 / f3);
    }

    public static float dpToPx(float f) {
        return f * Resources.getSystem().getDisplayMetrics().density;
    }

    public static float getRawX(MotionEvent motionEvent, int n) {
        float f = motionEvent.getRawX();
        float f2 = motionEvent.getX();
        if (n < motionEvent.getPointerCount()) {
            return motionEvent.getX(n) + (f - f2);
        }
        return 0.0f;
    }

    public static float getRawY(MotionEvent motionEvent, int n) {
        float f = motionEvent.getRawY();
        float f2 = motionEvent.getY();
        if (n < motionEvent.getPointerCount()) {
            return motionEvent.getY(n) + (f - f2);
        }
        return 0.0f;
    }

    public static float pxToDp(float f) {
        return f / Resources.getSystem().getDisplayMetrics().density;
    }

    public static float pxToMm(float f, Context context) {
        return f / TypedValue.applyDimension((int)5, (float)1.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

