/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.SystemClock;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;

class AlarmSchedulerFlusher
implements SchedulerFlusher {
    private final Context context;
    private final AlarmManager manager;
    private PendingIntent pendingIntent;
    private final AlarmReceiver receiver;

    AlarmSchedulerFlusher(Context context, AlarmManager alarmManager, AlarmReceiver alarmReceiver) {
        this.context = context;
        this.manager = alarmManager;
        this.receiver = alarmReceiver;
    }

    PendingIntent obtainPendingIntent() {
        return this.pendingIntent;
    }

    @Override
    public void register() {
        Intent intent = this.receiver.supplyIntent();
        int n = Build.VERSION.SDK_INT >= 23 ? 0xC000000 : 0x8000000;
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent, (int)n);
        intent = new IntentFilter("com.mapbox.scheduler_flusher");
        this.context.registerReceiver((BroadcastReceiver)this.receiver, (IntentFilter)intent);
    }

    @Override
    public void schedule(long l) {
        long l2 = SchedulerFlusherFactory.flushingPeriod;
        this.manager.setInexactRepeating(3, l + l2, SchedulerFlusherFactory.flushingPeriod, this.pendingIntent);
    }

    boolean scheduleExact(long l) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.manager.setExact(3, SystemClock.elapsedRealtime() + l, this.pendingIntent);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregister() {
        PendingIntent pendingIntent = this.pendingIntent;
        if (pendingIntent != null) {
            this.manager.cancel(pendingIntent);
        }
        try {
            this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }
}

