/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryUtils;

public class AppUserTurnstile
extends Event
implements Parcelable {
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private static final String APP_USER_TURNSTILE = "appUserTurnstile";
    public static final Parcelable.Creator<AppUserTurnstile> CREATOR;
    private static final String OPERATING_SYSTEM;
    @SerializedName(value="accuracyAuthorization")
    private String accuracyAuthorization;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="device")
    private final String device;
    @SerializedName(value="enabled.telemetry")
    private final boolean enabledTelemetry;
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="model")
    private final String model;
    @SerializedName(value="operatingSystem")
    private final String operatingSystem;
    @SerializedName(value="sdkIdentifier")
    private final String sdkIdentifier;
    @SerializedName(value="sdkVersion")
    private final String sdkVersion;
    @SerializedName(value="skuId")
    private String skuId;
    @SerializedName(value="userId")
    private final String userId;

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Android - ");
        stringBuilder.append(Build.VERSION.RELEASE);
        OPERATING_SYSTEM = stringBuilder.toString();
        CREATOR = new Parcelable.Creator<AppUserTurnstile>(){

            public AppUserTurnstile createFromParcel(Parcel parcel) {
                return new AppUserTurnstile(parcel);
            }

            public AppUserTurnstile[] newArray(int n) {
                return new AppUserTurnstile[n];
            }
        };
    }

    private AppUserTurnstile(Parcel parcel) {
        this.event = parcel.readString();
        this.created = parcel.readString();
        this.userId = parcel.readString();
        boolean bl = parcel.readByte() != 0;
        this.enabledTelemetry = bl;
        this.device = parcel.readString();
        this.sdkIdentifier = parcel.readString();
        this.sdkVersion = parcel.readString();
        this.model = parcel.readString();
        this.operatingSystem = parcel.readString();
        this.skuId = parcel.readString();
    }

    public AppUserTurnstile(String string2, String string3) {
        this(string2, string3, true);
    }

    AppUserTurnstile(String string2, String string3, boolean bl) {
        this.checkApplicationContext();
        this.event = APP_USER_TURNSTILE;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.userId = TelemetryUtils.retrieveVendorId();
        TelemetryEnabler telemetryEnabler = new TelemetryEnabler(bl);
        this.enabledTelemetry = TelemetryEnabler.TELEMETRY_STATES.get((Object)telemetryEnabler.obtainTelemetryState());
        this.device = Build.DEVICE;
        this.sdkIdentifier = string2;
        this.sdkVersion = string3;
        this.model = Build.MODEL;
        this.operatingSystem = OPERATING_SYSTEM;
    }

    private void checkApplicationContext() {
        if (MapboxTelemetry.applicationContext != null) {
            return;
        }
        throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
    }

    public int describeContents() {
        return 0;
    }

    public String getAccuracyAuthorization() {
        return this.accuracyAuthorization;
    }

    public String getSkuId() {
        return this.skuId;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.TURNSTILE;
    }

    public void setAccuracyAuthorization(String string2) {
        this.accuracyAuthorization = string2;
    }

    public void setSkuId(String string2) {
        if (string2 != null && string2.length() != 0) {
            this.skuId = string2;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.event);
        parcel.writeString(this.created);
        parcel.writeString(this.userId);
        parcel.writeByte((byte)(this.enabledTelemetry ? 1 : 0));
        parcel.writeString(this.device);
        parcel.writeString(this.sdkIdentifier);
        parcel.writeString(this.sdkVersion);
        parcel.writeString(this.model);
        parcel.writeString(this.operatingSystem);
        parcel.writeString(this.skuId);
    }
}

