/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.util.Log;
import com.mapbox.android.telemetry.ConcurrentQueue;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FullQueueCallback;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

class EventsQueue {
    private static final String LOG_TAG = "EventsQueue";
    static final int SIZE_LIMIT = 180;
    private final FullQueueCallback callback;
    private final ExecutorService executorService;
    private final ConcurrentQueue<Event> queue;

    EventsQueue(ConcurrentQueue<Event> concurrentQueue, FullQueueCallback fullQueueCallback, ExecutorService executorService) {
        this.queue = concurrentQueue;
        this.callback = fullQueueCallback;
        this.executorService = executorService;
    }

    static EventsQueue create(FullQueueCallback object, ExecutorService executorService) {
        synchronized (EventsQueue.class) {
            if (object != null && executorService != null) {
                ConcurrentQueue<Event> concurrentQueue = new ConcurrentQueue<Event>();
                object = new EventsQueue(concurrentQueue, (FullQueueCallback)object, executorService);
                return object;
            }
            try {
                object = new IllegalArgumentException("Callback or executor can't be null");
                throw object;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    private void dispatchCallback(final List<Event> list) {
        try {
            ExecutorService executorService = this.executorService;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventsQueue.this.callback.onFullQueue(list);
                    }
                    catch (Throwable throwable) {
                        Log.e((String)EventsQueue.LOG_TAG, (String)throwable.toString());
                    }
                }
            };
            executorService.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)LOG_TAG, (String)rejectedExecutionException.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Event> flush() {
        synchronized (this) {
            return this.queue.flush();
        }
    }

    boolean isEmpty() {
        boolean bl = this.queue.size() == 0;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean push(Event event) {
        synchronized (this) {
            if (this.queue.size() < 180) return this.queue.add(event);
            this.dispatchCallback(this.queue.flush());
            return this.queue.add(event);
        }
    }

    int size() {
        return this.queue.size();
    }
}

