/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;

final class GzipRequestInterceptor
implements Interceptor {
    private static final int THREAD_ID = 10000;

    GzipRequestInterceptor() {
    }

    private RequestBody gzip(final RequestBody requestBody) {
        return new RequestBody(){

            public long contentLength() {
                return -1L;
            }

            public MediaType contentType() {
                return requestBody.contentType();
            }

            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink = Okio.buffer((Sink)new GzipSink((Sink)bufferedSink));
                requestBody.writeTo(bufferedSink);
                bufferedSink.close();
            }
        };
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (request.body() != null && request.header("Content-Encoding") == null) {
            return chain.proceed(request.newBuilder().header("Content-Encoding", "gzip").method(request.method(), this.gzip(request.body())).build());
        }
        return chain.proceed(request);
    }
}

