/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.AlarmReceiver;
import com.mapbox.android.telemetry.AppUserTurnstile;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Clock;
import com.mapbox.android.telemetry.ConfigurationClient;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.FullQueueCallback;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherFactory;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionInterval;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientFactory;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.TelemetryUtils;
import com.mapbox.android.telemetry.errors.ErrorReporterEngine;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public class MapboxTelemetry
implements FullQueueCallback,
ServiceTaskCallback {
    private static final String LOG_TAG = "MapboxTelemetry";
    private static final String NON_NULL_APPLICATION_CONTEXT_REQUIRED = "Non-null application context required.";
    static Context applicationContext;
    private static AtomicReference<String> sAccessToken;
    private CopyOnWriteArraySet<AttachmentListener> attachmentListeners = null;
    private CertificateBlacklist certificateBlacklist;
    private Clock clock = null;
    private ConfigurationClient configurationClient;
    private final ExecutorService executorService;
    private Callback httpCallback;
    private final EventsQueue queue;
    private final SchedulerFlusher schedulerFlusher;
    private TelemetryClient telemetryClient;
    private final TelemetryEnabler telemetryEnabler;
    private CopyOnWriteArraySet<TelemetryListener> telemetryListeners = null;
    private String userAgent;

    static {
        sAccessToken = new AtomicReference<String>("");
        applicationContext = null;
    }

    public MapboxTelemetry(Context object, String string2, String string3) {
        ExecutorService executorService;
        this.initializeContext((Context)object);
        this.executorService = executorService = ExecutorServiceFactory.create("MapboxTelemetryExecutor", 3, 20L);
        MapboxTelemetry.setAccessToken(object, string2, executorService);
        this.userAgent = string3;
        object = this.obtainAlarmReceiver();
        this.schedulerFlusher = new SchedulerFlusherFactory(applicationContext, (AlarmReceiver)((Object)object)).supply();
        this.telemetryEnabler = new TelemetryEnabler(true);
        this.initializeTelemetryListeners();
        this.initializeAttachmentListeners();
        this.httpCallback = MapboxTelemetry.getHttpCallback(this.telemetryListeners);
        this.queue = EventsQueue.create(this, executorService);
    }

    MapboxTelemetry(Context context, String string2, String string3, EventsQueue eventsQueue, TelemetryClient telemetryClient, Callback callback, SchedulerFlusher schedulerFlusher, Clock clock, TelemetryEnabler telemetryEnabler, ExecutorService executorService) {
        this.initializeContext(context);
        MapboxTelemetry.setAccessToken(context, string2, executorService);
        this.userAgent = string3;
        this.telemetryClient = telemetryClient;
        this.schedulerFlusher = schedulerFlusher;
        this.clock = clock;
        this.telemetryEnabler = telemetryEnabler;
        this.initializeTelemetryListeners();
        this.initializeAttachmentListeners();
        this.httpCallback = callback;
        this.executorService = executorService;
        this.queue = eventsQueue;
    }

    private void addAccuracyAuthorization(AppUserTurnstile appUserTurnstile) {
        PermissionsManager.AccuracyAuthorization accuracyAuthorization = PermissionsManager.accuracyAuthorization(applicationContext);
        int n = 7.$SwitchMap$com$mapbox$android$core$permissions$PermissionsManager$AccuracyAuthorization[accuracyAuthorization.ordinal()];
        if (n != 1) {
            if (n == 2) {
                appUserTurnstile.setAccuracyAuthorization("reduced");
            }
        } else {
            appUserTurnstile.setAccuracyAuthorization("full");
        }
    }

    private boolean areRequiredParametersValid(String string2, String string3) {
        boolean bl = this.isAccessTokenValid(string2) && this.isUserAgentValid(string3);
        return bl;
    }

    private Boolean checkNetworkAndParameters() {
        boolean bl = this.isNetworkConnected() && this.checkRequiredParameters(sAccessToken.get(), this.userAgent);
        return bl;
    }

    private Attachment convertEventToAttachment(Event event) {
        return (Attachment)event;
    }

    private TelemetryClient createTelemetryClient(String object, String string2) {
        this.telemetryClient = object = this.getTelemetryClientFactory((String)object, string2).obtainTelemetryClient(applicationContext);
        return object;
    }

    private void enableLocationCollector(final boolean bl) {
        synchronized (this) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        SharedPreferences.Editor editor = TelemetryUtils.obtainSharedPreferences(applicationContext).edit();
                        editor.putBoolean("mapboxTelemetryLocationState", bl);
                        editor.apply();
                    }
                    catch (Throwable throwable) {
                        Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                    }
                }
            };
            this.executeRunnable(runnable);
            return;
        }
    }

    private void executeRunnable(Runnable runnable) {
        try {
            this.executorService.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            Log.e((String)LOG_TAG, (String)rejectedExecutionException.toString());
        }
    }

    private void flushEnqueuedEvents() {
        synchronized (this) {
            List<Event> list;
            block4: {
                list = this.queue.flush();
                boolean bl = list.isEmpty();
                if (!bl) break block4;
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MapboxTelemetry.this.sendEvents(list, false);
                    }
                    catch (Throwable throwable) {
                        Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                    }
                }
            };
            this.executeRunnable(runnable);
            return;
        }
    }

    private static Callback getHttpCallback(final Set<TelemetryListener> set) {
        return new Callback(){

            public void onFailure(Call object, IOException iOException) {
                object = set.iterator();
                while (object.hasNext()) {
                    ((TelemetryListener)object.next()).onHttpFailure(iOException.getMessage());
                }
            }

            public void onResponse(Call object, Response response) throws IOException {
                object = response.body();
                if (object != null) {
                    object.close();
                }
                object = set.iterator();
                while (object.hasNext()) {
                    ((TelemetryListener)object.next()).onHttpResponse(response.isSuccessful(), response.code());
                }
            }
        };
    }

    private void initializeAttachmentListeners() {
        this.attachmentListeners = new CopyOnWriteArraySet();
    }

    private void initializeContext(Context context) {
        if (applicationContext == null) {
            if (context != null && context.getApplicationContext() != null) {
                applicationContext = context.getApplicationContext();
            } else {
                throw new IllegalArgumentException(NON_NULL_APPLICATION_CONTEXT_REQUIRED);
            }
        }
    }

    private void initializeTelemetryClient() {
        if (this.configurationClient == null) {
            Context context = applicationContext;
            this.configurationClient = new ConfigurationClient(context, TelemetryUtils.createFullUserAgent(this.userAgent, context), sAccessToken.get(), new OkHttpClient());
        }
        if (this.certificateBlacklist == null) {
            this.certificateBlacklist = new CertificateBlacklist(applicationContext, this.configurationClient);
        }
        if (this.telemetryClient == null) {
            this.telemetryClient = this.createTelemetryClient(sAccessToken.get(), this.userAgent);
        }
    }

    private void initializeTelemetryListeners() {
        this.telemetryListeners = new CopyOnWriteArraySet();
    }

    private boolean isAccessTokenValid(String string2) {
        if (!TelemetryUtils.isEmpty(string2)) {
            sAccessToken.set(string2);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isNetworkConnected() {
        NetworkInfo networkInfo;
        block4: {
            boolean bl = false;
            try {
                networkInfo = ((ConnectivityManager)applicationContext.getSystemService("connectivity")).getActiveNetworkInfo();
                if (networkInfo != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return bl;
            }
        }
        boolean bl = networkInfo.isConnected();
        return bl;
    }

    private boolean isUserAgentValid(String string2) {
        if (!TelemetryUtils.isEmpty(string2)) {
            this.userAgent = string2;
            return true;
        }
        return false;
    }

    private static boolean isValidUrl(String string2) {
        Pattern pattern = Pattern.compile("^[a-z0-9]+([\\-.][a-z0-9]+)*\\.[a-z]{2,5}(:[0-9]{1,5})?(/.*)?$");
        boolean bl = string2 != null && !string2.isEmpty() && pattern.matcher(string2).matches();
        return bl;
    }

    private AlarmReceiver obtainAlarmReceiver() {
        return new AlarmReceiver(new SchedulerCallback(){

            @Override
            public void onError() {
            }

            @Override
            public void onPeriodRaised() {
                MapboxTelemetry.this.flushEnqueuedEvents();
            }
        });
    }

    private Clock obtainClock() {
        if (this.clock == null) {
            this.clock = new Clock();
        }
        return this.clock;
    }

    private void sendAttachment(Event event) {
        if (this.checkNetworkAndParameters().booleanValue()) {
            this.telemetryClient.sendAttachment(this.convertEventToAttachment(event), this.attachmentListeners);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendEventIfWhitelisted(final Event list) {
        synchronized (this) {
            block7: {
                boolean bl = false;
                int n = 7.$SwitchMap$com$mapbox$android$telemetry$Event$Type[((Event)((Object)list)).obtainType().ordinal()];
                if (n == 1 || n == 2) break block7;
                if (n != 3) return bl;
                this.sendAttachment((Event)((Object)list));
                return true;
            }
            list = Collections.singletonList(list);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MapboxTelemetry.this.sendEvents(list, true);
                    }
                    catch (Throwable throwable) {
                        Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                    }
                }
            };
            this.executeRunnable(runnable);
            return true;
        }
    }

    private void sendEvents(List<Event> list, boolean bl) {
        synchronized (this) {
            if (this.isNetworkConnected() && this.checkRequiredParameters(sAccessToken.get(), this.userAgent)) {
                this.telemetryClient.sendEvents(list, this.httpCallback, bl);
            }
            return;
        }
    }

    private static void setAccessToken(Context context, String string2, ExecutorService executorService) {
        synchronized (MapboxTelemetry.class) {
            block6: {
                boolean bl = TelemetryUtils.isEmpty(string2);
                if (!bl) break block6;
                return;
            }
            if (sAccessToken.getAndSet(string2).isEmpty()) {
                ErrorReporterEngine.sendErrorReports(context, executorService);
            }
            return;
        }
    }

    private void startAlarm() {
        this.schedulerFlusher.register();
        Clock clock = this.obtainClock();
        this.schedulerFlusher.schedule(clock.giveMeTheElapsedRealtime());
    }

    private void startTelemetry() {
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)state)) {
            this.startAlarm();
            this.enableLocationCollector(true);
        }
    }

    private void stopTelemetry() {
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)state)) {
            this.flushEnqueuedEvents();
            this.unregisterTelemetry();
            this.enableLocationCollector(false);
        }
    }

    private void unregisterTelemetry() {
        this.schedulerFlusher.unregister();
    }

    private boolean updateTelemetryClient(String string2) {
        TelemetryClient telemetryClient = this.telemetryClient;
        if (telemetryClient != null) {
            telemetryClient.updateAccessToken(string2);
            return true;
        }
        return false;
    }

    public boolean addAttachmentListener(AttachmentListener attachmentListener) {
        return this.attachmentListeners.add(attachmentListener);
    }

    public boolean addTelemetryListener(TelemetryListener telemetryListener) {
        return this.telemetryListeners.add(telemetryListener);
    }

    boolean checkRequiredParameters(String string2, String string3) {
        boolean bl = this.areRequiredParametersValid(string2, string3);
        if (bl) {
            this.initializeTelemetryClient();
        }
        return bl;
    }

    public boolean disable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            this.stopTelemetry();
            return true;
        }
        return false;
    }

    public boolean enable() {
        if (TelemetryEnabler.isEventsEnabled(applicationContext)) {
            this.startTelemetry();
            return true;
        }
        return false;
    }

    TelemetryClientFactory getTelemetryClientFactory(String string2, String string3) {
        return new TelemetryClientFactory(string2, TelemetryUtils.createFullUserAgent(string3, applicationContext), new Logger(), this.certificateBlacklist);
    }

    public boolean isCnRegion() {
        if (this.checkRequiredParameters(sAccessToken.get(), this.userAgent)) {
            return this.telemetryClient.isCnRegion();
        }
        return false;
    }

    boolean isQueueEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void onFullQueue(List<Event> list) {
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)state) && !TelemetryUtils.adjustWakeUpMode(applicationContext)) {
            this.sendEvents(list, false);
        }
    }

    @Override
    public void onTaskRemoved() {
        this.flushEnqueuedEvents();
        this.unregisterTelemetry();
    }

    public boolean push(Event event) {
        if (event instanceof AppUserTurnstile) {
            this.addAccuracyAuthorization((AppUserTurnstile)event);
        }
        if (this.sendEventIfWhitelisted(event)) {
            return true;
        }
        return this.pushToQueue(event);
    }

    boolean pushToQueue(Event event) {
        TelemetryEnabler.State state = this.telemetryEnabler.obtainTelemetryState();
        if (TelemetryEnabler.State.ENABLED.equals((Object)state)) {
            return this.queue.push(event);
        }
        return false;
    }

    public boolean removeAttachmentListener(AttachmentListener attachmentListener) {
        return this.attachmentListeners.remove(attachmentListener);
    }

    public boolean removeTelemetryListener(TelemetryListener telemetryListener) {
        return this.telemetryListeners.remove(telemetryListener);
    }

    @Deprecated
    public boolean setBaseUrl(String string2) {
        synchronized (this) {
            if (MapboxTelemetry.isValidUrl(string2) && this.checkNetworkAndParameters().booleanValue()) {
                this.telemetryClient.setBaseUrl(string2);
                return true;
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCnRegion(boolean bl) {
        synchronized (this) {
            boolean bl2 = this.isCnRegion();
            if (bl2 == bl) {
                return;
            }
            TelemetryClientFactory telemetryClientFactory = this.getTelemetryClientFactory(sAccessToken.get(), this.userAgent);
            Environment environment = bl ? Environment.CHINA : Environment.COM;
            this.telemetryClient = telemetryClientFactory.obtainTelemetryClient(environment, applicationContext);
            return;
        }
    }

    public boolean updateAccessToken(String string2) {
        if (this.isAccessTokenValid(string2) && this.updateTelemetryClient(string2)) {
            sAccessToken.set(string2);
            return true;
        }
        return false;
    }

    public void updateDebugLoggingEnabled(boolean bl) {
        TelemetryClient telemetryClient = this.telemetryClient;
        if (telemetryClient != null) {
            telemetryClient.updateDebugLoggingEnabled(bl);
        }
    }

    public boolean updateSessionIdRotationInterval(SessionInterval sessionInterval) {
        this.executeRunnable(new Runnable(sessionInterval.obtainInterval()){
            final /* synthetic */ long val$intervalHours;
            {
                this.val$intervalHours = l;
            }

            @Override
            public void run() {
                try {
                    SharedPreferences.Editor editor = TelemetryUtils.obtainSharedPreferences(applicationContext).edit();
                    editor.putLong("mapboxSessionRotationInterval", TimeUnit.HOURS.toMillis(this.val$intervalHours));
                    editor.apply();
                }
                catch (Throwable throwable) {
                    Log.e((String)MapboxTelemetry.LOG_TAG, (String)throwable.toString());
                }
            }
        });
        return true;
    }

    public void updateUserAgent(String string2) {
        if (this.isUserAgentValid(string2)) {
            this.telemetryClient.updateUserAgent(TelemetryUtils.createFullUserAgent(string2, applicationContext));
        }
    }

    private static final class ExecutorServiceFactory {
        private ExecutorServiceFactory() {
        }

        private static ExecutorService create(String object, int n, long l) {
            synchronized (ExecutorServiceFactory.class) {
                TimeUnit timeUnit = TimeUnit.SECONDS;
                LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
                object = new ThreadPoolExecutor(0, n, l, timeUnit, linkedBlockingQueue, ExecutorServiceFactory.threadFactory((String)object));
                return object;
            }
        }

        private static ThreadFactory threadFactory(final String string2) {
            return new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    return new Thread(runnable, string2);
                }
            };
        }
    }
}

