/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import com.mapbox.android.telemetry.AppStateUtils;
import com.mapbox.android.telemetry.LogUtils;

public class MapboxTelemetryService
extends Service {
    private final String TAG;
    private final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
    private Application application = null;
    private final IBinder binder = new Binder();

    public MapboxTelemetryService() {
        this.TAG = "MapboxTelemetryService";
        this.activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_CREATED);
            }

            public void onActivityDestroyed(Activity activity) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_DESTROYED);
            }

            public void onActivityPaused(Activity activity) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_PAUSED);
            }

            public void onActivityResumed(Activity activity) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_RESUMED);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_SAVE_INSTANCE_STATE);
            }

            public void onActivityStarted(Activity activity) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_STARTED);
            }

            public void onActivityStopped(Activity activity) {
                MapboxTelemetryService.this.saveActivityState(AppStateUtils.ActivityState.ACTIVITY_STATE_STOPPED);
            }
        };
    }

    private void resetActivityStateToUnknown() {
        AppStateUtils.saveActivityState((Context)this, AppStateUtils.ActivityState.ACTIVITY_STATE_UNKNOWN);
    }

    private void saveActivityState(AppStateUtils.ActivityState activityState) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Activity state: ");
        stringBuilder.append((Object)activityState);
        LogUtils.v("MapboxTelemetryService", stringBuilder.toString(), new Object[0]);
        AppStateUtils.saveActivityState((Context)this, activityState);
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onCreate() {
        Application application;
        LogUtils.d("MapboxTelemetryService", "Starting telemetry service...", new Object[0]);
        this.resetActivityStateToUnknown();
        this.application = application = this.getApplication();
        application.registerActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    public void onDestroy() {
        LogUtils.d("MapboxTelemetryService", "Stopping telemetry service..", new Object[0]);
        this.application.unregisterActivityLifecycleCallbacks(this.activityLifecycleCallbacks);
    }

    public class Binder
    extends android.os.Binder {
        public MapboxTelemetryService getService() {
            return MapboxTelemetryService.this;
        }
    }
}

