/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.android.telemetry.Attachment;
import com.mapbox.android.telemetry.AttachmentListener;
import com.mapbox.android.telemetry.AttachmentMetadata;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FileAttachment;
import com.mapbox.android.telemetry.FileData;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class TelemetryClient {
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String ATTACHMENTS_ENDPOINT = "/attachments/v1";
    private static final String BOUNDARY = "--01ead4a5-7a67-4703-ad02-589886e00923";
    private static final String EVENTS_ENDPOINT = "/events/v2";
    private static final String EXTRA_DEBUGGING_LOG = "Sending POST to %s with %d event(s) (user agent: %s) with payload: %s";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final String LOG_TAG = "TelemetryClient";
    private static final String MAPBOX_AGENT_REQUEST_HEADER = "X-Mapbox-Agent";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private String accessToken;
    private CertificateBlacklist certificateBlacklist;
    private boolean isCnRegion;
    private final Logger logger;
    private String reformedUserAgent;
    private TelemetryClientSettings setting;
    private String userAgent;

    TelemetryClient(String string2, String string3, String string4, TelemetryClientSettings telemetryClientSettings, Logger logger, CertificateBlacklist certificateBlacklist, boolean bl) {
        this.accessToken = string2;
        this.userAgent = string3;
        this.reformedUserAgent = string4;
        this.setting = telemetryClientSettings;
        this.logger = logger;
        this.certificateBlacklist = certificateBlacklist;
        this.isCnRegion = bl;
    }

    private boolean isExtraDebuggingNeeded() {
        boolean bl = this.setting.isDebugLoggingEnabled() || this.setting.getEnvironment().equals((Object)Environment.STAGING);
        return bl;
    }

    private RequestBody reverseMultiForm(MultipartBody.Builder builder) {
        MultipartBody multipartBody = builder.build();
        builder = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        for (int i = multipartBody.size() - 1; i > -1; --i) {
            builder.addPart(multipartBody.part(i));
        }
        return builder.build();
    }

    private void sendBatch(List<Event> list, Callback callback, boolean bl) {
        Object object = bl ? new GsonBuilder().serializeNulls().create() : new Gson();
        object = ((Gson)object).toJson(list);
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)object);
        HttpUrl httpUrl = this.setting.getBaseUrl().newBuilder(EVENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        if (this.isExtraDebuggingNeeded()) {
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, httpUrl, list.size(), this.userAgent, object));
        }
        object = new Request.Builder().url(httpUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).addHeader(MAPBOX_AGENT_REQUEST_HEADER, this.reformedUserAgent).post(requestBody).build();
        this.setting.getClient(this.certificateBlacklist, list.size()).newCall((Request)object).enqueue(callback);
    }

    boolean isCnRegion() {
        return this.isCnRegion;
    }

    String obtainAccessToken() {
        return this.accessToken;
    }

    TelemetryClientSettings obtainSetting() {
        return this.setting;
    }

    void sendAttachment(final Attachment object, final CopyOnWriteArraySet<AttachmentListener> copyOnWriteArraySet) {
        FileData fileData;
        List<FileAttachment> list = ((Attachment)((Object)object)).getAttachments();
        Request request = new ArrayList();
        object = new ArrayList<String>();
        MultipartBody.Builder builder = new MultipartBody.Builder(BOUNDARY).setType(MultipartBody.FORM);
        for (FileAttachment fileAttachment : list) {
            fileData = fileAttachment.getFileData();
            AttachmentMetadata object2 = fileAttachment.getAttachmentMetadata();
            request.add(object2);
            builder.addFormDataPart("file", object2.getName(), RequestBody.create((MediaType)fileData.getType(), (File)new File(fileData.getFilePath())));
            object.add(object2.getFileId());
        }
        builder.addFormDataPart("attachments", new Gson().toJson(request));
        fileData = this.reverseMultiForm(builder);
        HttpUrl httpUrl = this.setting.getBaseUrl().newBuilder(ATTACHMENTS_ENDPOINT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, this.accessToken).build();
        if (this.isExtraDebuggingNeeded()) {
            this.logger.debug(LOG_TAG, String.format(Locale.US, EXTRA_DEBUGGING_LOG, httpUrl, list.size(), this.userAgent, request));
        }
        request = new Request.Builder().url(httpUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).addHeader(MAPBOX_AGENT_REQUEST_HEADER, this.reformedUserAgent).post((RequestBody)fileData).build();
        this.setting.getAttachmentClient(this.certificateBlacklist).newCall(request).enqueue(new Callback(){

            public void onFailure(Call object2, IOException iOException) {
                object2 = copyOnWriteArraySet.iterator();
                while (object2.hasNext()) {
                    ((AttachmentListener)object2.next()).onAttachmentFailure(iOException.getMessage(), object);
                }
            }

            public void onResponse(Call object2, Response response) {
                object2 = copyOnWriteArraySet.iterator();
                while (object2.hasNext()) {
                    ((AttachmentListener)object2.next()).onAttachmentResponse(response.message(), response.code(), object);
                }
            }
        });
    }

    void sendEvents(List<Event> list, Callback callback, boolean bl) {
        this.sendBatch(Collections.unmodifiableList(list), callback, bl);
    }

    void setBaseUrl(String string2) {
        synchronized (this) {
            string2 = TelemetryClientSettings.configureUrlHostname(string2);
            this.setting = this.setting.toBuilder().baseUrl((HttpUrl)string2).build();
            return;
        }
    }

    void updateAccessToken(String string2) {
        this.accessToken = string2;
    }

    void updateDebugLoggingEnabled(boolean bl) {
        this.setting = this.setting.toBuilder().debugLoggingEnabled(bl).build();
    }

    void updateUserAgent(String string2) {
        this.userAgent = string2;
    }
}

