/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.TrafficStats;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.android.core.MapboxSdkInfoForUserAgentGenerator;
import com.mapbox.android.telemetry.MapboxTelemetry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;
import okio.Buffer;

public class TelemetryUtils {
    private static final String BACKGROUND = "Background";
    private static final String CODE_DIVISION_MULTIPLE_ACCESS = "CDMA";
    private static final String DATE_AND_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final int DEFAULT_BATTERY_LEVEL = -1;
    private static final Locale DEFAULT_LOCALE;
    private static final String EMPTY_STRING = "";
    private static final String ENHANCED_DATA_GSM_EVOLUTION = "EDGE";
    private static final String ENHANCED_HIGH_RATE_PACKET_DATA = "EHRPD";
    private static final String EVOLUTION_DATA_OPTIMIZED_0 = "EVDO_0";
    private static final String EVOLUTION_DATA_OPTIMIZED_A = "EVDO_A";
    private static final String EVOLUTION_DATA_OPTIMIZED_B = "EVDO_B";
    private static final String FOREGROUND = "Foreground";
    private static final String GENERAL_PACKET_RADIO_SERVICE = "GPRS";
    private static final String HIGH_SPEED_DOWNLINK_PACKET_ACCESS = "HSDPA";
    private static final String HIGH_SPEED_PACKET_ACCESS = "HSPA";
    private static final String HIGH_SPEED_PACKET_ACCESS_PLUS = "HSPAP";
    private static final String HIGH_SPEED_UNLINK_PACKET_ACCESS = "HSUPA";
    private static final String INTEGRATED_DIGITAL_ENHANCED_NETWORK = "IDEN";
    private static final String KEY_META_DATA_WAKE_UP = "com.mapbox.AdjustWakeUp";
    private static final String LONG_TERM_EVOLUTION = "LTE";
    static final String MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID = "mapboxVendorId";
    private static final Map<Integer, String> NETWORKS;
    private static final String NO_STATE = "";
    private static final String OPERATING_SYSTEM;
    private static final int PERCENT_SCALE = 100;
    private static final String SINGLE_CARRIER_RTT = "1xRTT";
    private static final String TAG = "TelemetryUtils";
    private static final String THREE_STRING_FORMAT = "%s/%s/%s";
    private static final String TWO_STRING_FORMAT = "%s %s";
    private static final int UNAVAILABLE_BATTERY_LEVEL = -1;
    private static final String UNIVERSAL_MOBILE_TELCO_SERVICE = "UMTS";
    private static final String UNKNOWN = "Unknown";
    private static final String USER_AGENT_APP_ID_FORMAT = "%s/%s (%s; %s; %s)";
    private static final String USER_AGENT_VERSION_CODE_FORMAT = "v%d";
    private static final SimpleDateFormat dateFormat;

    static {
        dateFormat = new SimpleDateFormat(DATE_AND_TIME_PATTERN, Locale.US);
        DEFAULT_LOCALE = Locale.US;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Android - ");
        stringBuilder.append(Build.VERSION.RELEASE);
        OPERATING_SYSTEM = stringBuilder.toString();
        NETWORKS = new HashMap<Integer, String>(){
            {
                this.put(7, TelemetryUtils.SINGLE_CARRIER_RTT);
                this.put(4, TelemetryUtils.CODE_DIVISION_MULTIPLE_ACCESS);
                this.put(2, TelemetryUtils.ENHANCED_DATA_GSM_EVOLUTION);
                this.put(14, TelemetryUtils.ENHANCED_HIGH_RATE_PACKET_DATA);
                this.put(5, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_0);
                this.put(6, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_A);
                this.put(12, TelemetryUtils.EVOLUTION_DATA_OPTIMIZED_B);
                this.put(1, TelemetryUtils.GENERAL_PACKET_RADIO_SERVICE);
                this.put(8, TelemetryUtils.HIGH_SPEED_DOWNLINK_PACKET_ACCESS);
                this.put(10, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS);
                this.put(15, TelemetryUtils.HIGH_SPEED_PACKET_ACCESS_PLUS);
                this.put(9, TelemetryUtils.HIGH_SPEED_UNLINK_PACKET_ACCESS);
                this.put(11, TelemetryUtils.INTEGRATED_DIGITAL_ENHANCED_NETWORK);
                this.put(13, TelemetryUtils.LONG_TERM_EVOLUTION);
                this.put(3, TelemetryUtils.UNIVERSAL_MOBILE_TELCO_SERVICE);
                this.put(0, TelemetryUtils.UNKNOWN);
            }
        };
    }

    static boolean adjustWakeUpMode(Context context) {
        block4: {
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (context == null) break block4;
            try {
                if (context.metaData != null) {
                    boolean bl = context.metaData.getBoolean(KEY_META_DATA_WAKE_UP, false);
                    return bl;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return false;
    }

    static String createFullUserAgent(String string2, Context object) {
        String string3 = TelemetryUtils.obtainApplicationIdentifier(object);
        object = TelemetryUtils.toHumanReadableAscii(String.format(DEFAULT_LOCALE, TWO_STRING_FORMAT, string3, string2));
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string2 = object;
        }
        return string2;
    }

    static OkHttpClient createOkHttpClientWithStrictModeWorkAround() {
        return new OkHttpClient().newBuilder().socketFactory(new SocketFactory(){
            private static final int THREAD_ID = 10000;
            SocketFactory socketFactory = SocketFactory.getDefault();

            @Override
            public Socket createSocket(String string2, int n) throws IOException, UnknownHostException {
                TrafficStats.setThreadStatsTag((int)10000);
                return this.socketFactory.createSocket(string2, n);
            }

            @Override
            public Socket createSocket(String string2, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
                TrafficStats.setThreadStatsTag((int)10000);
                return this.socketFactory.createSocket(string2, n, inetAddress, n2);
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
                TrafficStats.setThreadStatsTag((int)10000);
                return this.socketFactory.createSocket(inetAddress, n);
            }

            @Override
            public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
                TrafficStats.setThreadStatsTag((int)10000);
                return this.socketFactory.createSocket(inetAddress, n, inetAddress2, n2);
            }
        }).build();
    }

    static String createReformedFullUserAgent(Context object) {
        block0: {
            String string2 = TelemetryUtils.obtainApplicationIdentifierForReformedUserAgent(object);
            if (!TextUtils.isEmpty((CharSequence)(object = TelemetryUtils.toHumanReadableAscii(String.format(DEFAULT_LOCALE, TWO_STRING_FORMAT, string2, MapboxSdkInfoForUserAgentGenerator.getInstance(object.getAssets()).getSdkInfoForUserAgent()))))) break block0;
            object = string2;
        }
        return object;
    }

    public static String generateCreateDateFormatted(Date date) {
        return dateFormat.format(date);
    }

    private static String getApplicationName(Context object) {
        Object object2 = object.getApplicationContext().getPackageManager();
        try {
            object = object2.getApplicationInfo(object.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = null;
        }
        object = object != null ? object2.getApplicationLabel((ApplicationInfo)object) : "(unknown)";
        object2 = (String)object;
        object = (String)object2;
        return object2;
    }

    static boolean isEmpty(String string2) {
        return string2 == null || string2.length() == 0;
        {
        }
    }

    public static boolean isPluggedIn(Context context) {
        context = TelemetryUtils.registerBatteryUpdates(context);
        boolean bl = false;
        if (context == null) {
            return false;
        }
        int n = context.getIntExtra("plugged", -1);
        boolean bl2 = n == 2;
        n = n == 1 ? 1 : 0;
        if (bl2 || n != 0) {
            bl = true;
        }
        return bl;
    }

    private static String obtainApplicationIdentifier(Context object) {
        try {
            String string2 = object.getPackageName();
            object = object.getPackageManager().getPackageInfo(string2, 0);
            object = String.format(DEFAULT_LOCALE, THREE_STRING_FORMAT, string2, object.versionName, object.versionCode);
            return object;
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String obtainApplicationIdentifierForReformedUserAgent(Context object) {
        void var2_7;
        String string2;
        Locale locale;
        PackageInfo packageInfo;
        String string3;
        block3: {
            try {
                string3 = object.getPackageName();
                packageInfo = object.getPackageManager().getPackageInfo(string3, 0);
                locale = DEFAULT_LOCALE;
                string2 = String.format(locale, USER_AGENT_VERSION_CODE_FORMAT, packageInfo.versionCode);
                if (packageInfo.versionName != null) break block3;
                String string4 = "0";
                return String.format(locale, USER_AGENT_APP_ID_FORMAT, TelemetryUtils.getApplicationName(object), var2_7, string3, string2, OPERATING_SYSTEM);
            }
            catch (Exception exception) {
                return "";
            }
        }
        String string5 = packageInfo.versionName;
        return String.format(locale, USER_AGENT_APP_ID_FORMAT, TelemetryUtils.getApplicationName(object), var2_7, string3, string2, OPERATING_SYSTEM);
    }

    public static String obtainApplicationState(Context object) {
        List list2 = ((ActivityManager)object.getSystemService("activity")).getRunningAppProcesses();
        if (list2 == null) {
            return "";
        }
        object = object.getPackageName();
        for (List list2 : list2) {
            if (((ActivityManager.RunningAppProcessInfo)list2).importance != 100 || !((ActivityManager.RunningAppProcessInfo)list2).processName.equals(object)) continue;
            return FOREGROUND;
        }
        return BACKGROUND;
    }

    public static int obtainBatteryLevel(Context context) {
        if ((context = TelemetryUtils.registerBatteryUpdates(context)) == null) {
            return -1;
        }
        int n = context.getIntExtra("level", -1);
        int n2 = context.getIntExtra("scale", -1);
        if (n >= 0 && n2 > 0) {
            return Math.round((float)n / (float)n2 * 100.0f);
        }
        return -1;
    }

    public static String obtainCellularNetworkType(Context context) {
        int n;
        context = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                n = context.getDataNetworkType();
            }
            catch (SecurityException securityException) {
                Log.w((String)TAG, (String)securityException.toString());
                n = 0;
            }
        } else {
            n = context.getNetworkType();
        }
        return NETWORKS.get(n);
    }

    public static String obtainCurrentDate() {
        return dateFormat.format(new Date());
    }

    static SharedPreferences obtainSharedPreferences(Context context) {
        return context.getSharedPreferences("MapboxSharedPreferences", 0);
    }

    public static String obtainUniversalUniqueIdentifier() {
        return UUID.randomUUID().toString();
    }

    private static Intent registerBatteryUpdates(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context = context.registerReceiver(null, intentFilter);
            return context;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)String.format("%s: Failed receiver registration for ACTION_BATTERY_CHANGED", exception.toString()));
            return null;
        }
    }

    public static String retrieveVendorId() {
        String string2;
        if (MapboxTelemetry.applicationContext == null) {
            return TelemetryUtils.updateVendorId();
        }
        String string3 = string2 = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext).getString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, "");
        if (TelemetryUtils.isEmpty(string2)) {
            string3 = TelemetryUtils.updateVendorId();
        }
        return string3;
    }

    public static String toHumanReadableAscii(String string2) {
        String string3;
        block2: {
            int n;
            int n2 = string2.length();
            int n3 = 0;
            while (true) {
                string3 = string2;
                if (n3 >= n2) break block2;
                n = string2.codePointAt(n3);
                if (n <= 31 || n >= 127) break;
                n3 += Character.charCount(n);
            }
            string3 = new Buffer();
            string3.writeUtf8(string2, 0, n3);
            while (n3 < n2) {
                int n4 = string2.codePointAt(n3);
                n = n4 > 31 && n4 < 127 ? n4 : 63;
                string3.writeUtf8CodePoint(n);
                n3 += Character.charCount(n4);
            }
            string3 = string3.readUtf8();
        }
        return string3;
    }

    private static String updateVendorId() {
        String string2 = TelemetryUtils.obtainUniversalUniqueIdentifier();
        if (MapboxTelemetry.applicationContext == null) {
            return string2;
        }
        SharedPreferences.Editor editor = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext).edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_VENDOR_ID, string2);
        editor.apply();
        return string2;
    }
}

