/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;

public class VisionObjectDetectionEvent
extends Event
implements Parcelable {
    public static final Parcelable.Creator<VisionObjectDetectionEvent> CREATOR = new Parcelable.Creator<VisionObjectDetectionEvent>(){

        public VisionObjectDetectionEvent createFromParcel(Parcel parcel) {
            return new VisionObjectDetectionEvent(parcel);
        }

        public VisionObjectDetectionEvent[] newArray(int n) {
            return new VisionObjectDetectionEvent[n];
        }
    };
    static final String VIS_OBJECT_DETECTION = "vision.objectDetection";
    @SerializedName(value="class")
    private String clazz;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="distance_from_camera")
    private Double distance_from_camera;
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="object_lat")
    private Double object_lat;
    @SerializedName(value="object_lon")
    private Double object_lon;
    @SerializedName(value="object_pos_height")
    private Double object_pos_height;
    @SerializedName(value="object_size_height")
    private Double object_size_height;
    @SerializedName(value="object_size_width")
    private Double object_size_width;
    @SerializedName(value="sign_value")
    private String sign_value;
    @SerializedName(value="vehicle_lat")
    private Double vehicle_lat;
    @SerializedName(value="vehicle_lon")
    private Double vehicle_lon;

    private VisionObjectDetectionEvent(Parcel parcel) {
        this.event = parcel.readString();
        this.created = parcel.readString();
        this.object_lat = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.object_lon = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.vehicle_lat = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.vehicle_lon = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.clazz = VisionObjectDetectionEvent.readStringIfNotNull(parcel);
        this.sign_value = VisionObjectDetectionEvent.readStringIfNotNull(parcel);
        this.object_size_width = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.object_size_height = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.object_pos_height = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
        this.distance_from_camera = VisionObjectDetectionEvent.readDoubleIfNotNull(parcel);
    }

    public VisionObjectDetectionEvent(String string2) {
        this.event = VIS_OBJECT_DETECTION;
        this.created = string2;
        this.object_lat = null;
        this.object_lon = null;
        this.vehicle_lat = null;
        this.vehicle_lon = null;
        this.clazz = null;
        this.sign_value = null;
        this.object_size_height = null;
        this.object_size_width = null;
        this.object_pos_height = null;
        this.distance_from_camera = null;
    }

    private static Double readDoubleIfNotNull(Parcel object) {
        object = object.readByte() == 0 ? null : Double.valueOf(object.readDouble());
        return object;
    }

    private static String readStringIfNotNull(Parcel object) {
        object = object.readByte() == 0 ? null : object.readString();
        return object;
    }

    private static void writeDoubleIfNotNull(Parcel parcel, Double d) {
        boolean bl = d != null;
        parcel.writeByte((byte)(bl ? 1 : 0));
        if (d != null) {
            parcel.writeDouble(d.doubleValue());
        }
    }

    private static void writeStringIfNotNull(Parcel parcel, String string2) {
        boolean bl = string2 != null;
        parcel.writeByte((byte)(bl ? 1 : 0));
        if (string2 != null) {
            parcel.writeString(string2);
        }
    }

    public int describeContents() {
        return 0;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getCreated() {
        return this.created;
    }

    public double getDistanceFromCamera() {
        return this.distance_from_camera;
    }

    public String getEvent() {
        return this.event;
    }

    public double getObjectLatitude() {
        return this.object_lat;
    }

    public double getObjectLongitude() {
        return this.object_lon;
    }

    public double getObjectPositionHeight() {
        return this.object_pos_height;
    }

    public double getObjectSizeHeight() {
        return this.object_size_height;
    }

    public double getObjectSizeWidth() {
        return this.object_size_width;
    }

    public String getSignValue() {
        return this.sign_value;
    }

    public double getVehicleLatitude() {
        return this.vehicle_lat;
    }

    public double getVehicleLongitude() {
        return this.vehicle_lon;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.VIS_OBJ_DETECTION;
    }

    public void setClazz(String string2) {
        this.clazz = string2;
    }

    public void setDistanceFromCamera(double d) {
        this.distance_from_camera = d;
    }

    public void setObjectLatitude(double d) {
        this.object_lat = d;
    }

    public void setObjectLongitude(double d) {
        this.object_lon = d;
    }

    public void setObjectPositionHeight(double d) {
        this.object_pos_height = d;
    }

    public void setObjectSizeHeight(double d) {
        this.object_size_height = d;
    }

    public void setObjectSizeWidth(double d) {
        this.object_size_width = d;
    }

    public void setSignValue(String string2) {
        this.sign_value = string2;
    }

    public void setVehicleLatitude(double d) {
        this.vehicle_lat = d;
    }

    public void setVehicleLongitude(double d) {
        this.vehicle_lon = d;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.event);
        parcel.writeString(this.created);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.object_lat);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.object_lon);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.vehicle_lat);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.vehicle_lon);
        VisionObjectDetectionEvent.writeStringIfNotNull(parcel, this.clazz);
        VisionObjectDetectionEvent.writeStringIfNotNull(parcel, this.sign_value);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.object_size_width);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.object_size_height);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.object_pos_height);
        VisionObjectDetectionEvent.writeDoubleIfNotNull(parcel, this.distance_from_camera);
    }
}

