/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.errors;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.errors.ErrorReporterClient;
import java.io.File;
import java.util.concurrent.ExecutorService;

public final class ErrorReporterEngine {
    private static final String LOG_TAG = "CrashReporter";

    static void handleErrorReports(ErrorReporterClient errorReporterClient) {
        if (!errorReporterClient.isEnabled()) {
            Log.w((String)LOG_TAG, (String)"Crash reporter is disabled");
            return;
        }
        while (errorReporterClient.hasNextEvent()) {
            CrashEvent crashEvent = errorReporterClient.nextEvent();
            if (errorReporterClient.isDuplicate(crashEvent)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Skip duplicate crash in this batch: ");
                stringBuilder.append(crashEvent.getHash());
                Log.d((String)LOG_TAG, (String)stringBuilder.toString());
                errorReporterClient.delete(crashEvent);
                continue;
            }
            if (errorReporterClient.send(crashEvent)) {
                errorReporterClient.delete(crashEvent);
                continue;
            }
            Log.w((String)LOG_TAG, (String)"Failed to deliver crash event");
        }
    }

    public static void sendErrorReports(final Context context, ExecutorService executorService) {
        if (Build.VERSION.SDK_INT < 26) {
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent("com.mapbox.android.telemetry.action.TOKEN_CHANGED"));
        } else {
            try {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        ErrorReporterEngine.sendReports(context);
                    }
                };
                executorService.execute(runnable);
            }
            catch (Throwable throwable) {
                Log.e((String)LOG_TAG, (String)throwable.toString());
            }
        }
    }

    static void sendReports(Context context) {
        if (context != null && context.getApplicationContext() != null) {
            File file = FileUtils.getFile(context.getApplicationContext(), "com.mapbox.android.telemetry");
            if (!file.exists()) {
                Log.w((String)LOG_TAG, (String)"Root directory doesn't exist");
                return;
            }
            ErrorReporterEngine.handleErrorReports(ErrorReporterClient.create(context.getApplicationContext()).loadFrom(file));
        }
    }
}

