/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.location.LocationEngineController;
import com.mapbox.android.telemetry.location.LocationEngineControllerImpl;
import com.mapbox.android.telemetry.location.LocationUpdatesBroadcastReceiver;
import com.mapbox.android.telemetry.location.SessionIdentifier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class LocationCollectionClient
implements SharedPreferences.OnSharedPreferenceChangeListener {
    public static final int DEFAULT_SESSION_ROTATION_INTERVAL_HOURS = 24;
    private static final int LOCATION_COLLECTION_STATUS_UPDATED = 0;
    private static final String LOCATION_COLLECTOR_USER_AGENT = "mapbox-android-location";
    private static final String TAG = "LocationCollectionCli";
    private static LocationCollectionClient locationCollectionClient;
    private static final Object lock;
    private final AtomicBoolean isEnabled = new AtomicBoolean(false);
    final LocationEngineController locationEngineController;
    private final AtomicReference<SessionIdentifier> sessionIdentifier;
    private Handler settingsChangeHandler;
    private final HandlerThread settingsChangeHandlerThread;
    private final SharedPreferences sharedPreferences;
    private final MapboxTelemetry telemetry;

    static {
        lock = new Object();
    }

    LocationCollectionClient(LocationEngineController locationEngineController, HandlerThread handlerThread, SessionIdentifier sessionIdentifier, SharedPreferences sharedPreferences, MapboxTelemetry mapboxTelemetry) {
        AtomicReference<SessionIdentifier> atomicReference = new AtomicReference<SessionIdentifier>();
        this.sessionIdentifier = atomicReference;
        this.locationEngineController = locationEngineController;
        this.settingsChangeHandlerThread = handlerThread;
        atomicReference.set(sessionIdentifier);
        this.telemetry = mapboxTelemetry;
        handlerThread.start();
        this.settingsChangeHandler = new Handler(handlerThread.getLooper()){

            public void handleMessage(Message message) {
                try {
                    LocationCollectionClient.this.handleSettingsChangeMessage(message);
                }
                catch (Throwable throwable) {
                    Log.e((String)LocationCollectionClient.TAG, (String)throwable.toString());
                }
            }
        };
        this.sharedPreferences = sharedPreferences;
        this.initializeSharedPreferences(sharedPreferences);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LocationCollectionClient getInstance() {
        Object object = lock;
        synchronized (object) {
            Object object2 = locationCollectionClient;
            if (object2 != null) {
                return object2;
            }
            object2 = new IllegalStateException("LocationCollectionClient is not installed.");
            throw object2;
        }
    }

    private void initializeSharedPreferences(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean("mapboxTelemetryLocationState", this.isEnabled.get());
        editor.putLong("mapboxSessionRotationInterval", this.sessionIdentifier.get().getInterval());
        editor.apply();
        sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocationCollectionClient install(Context context, long l) {
        if (context.getApplicationContext() != null) {
            context = context.getApplicationContext();
        }
        Object object = lock;
        synchronized (object) {
            if (locationCollectionClient == null) {
                LocationCollectionClient locationCollectionClient;
                Object object2 = LocationEngineProvider.getBestLocationEngine(context);
                LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver = new LocationUpdatesBroadcastReceiver();
                LocationEngineControllerImpl locationEngineControllerImpl = new LocationEngineControllerImpl(context, (LocationEngine)object2, locationUpdatesBroadcastReceiver);
                locationUpdatesBroadcastReceiver = new HandlerThread("LocationSettingsChangeThread");
                SessionIdentifier sessionIdentifier = new SessionIdentifier(l);
                SharedPreferences sharedPreferences = context.getSharedPreferences("MapboxSharedPreferences", 0);
                object2 = new MapboxTelemetry(context, "", String.format("%s/%s", LOCATION_COLLECTOR_USER_AGENT, "8.1.0-okhttp3"));
                LocationCollectionClient.locationCollectionClient = locationCollectionClient = new LocationCollectionClient(locationEngineControllerImpl, (HandlerThread)locationUpdatesBroadcastReceiver, sessionIdentifier, sharedPreferences, (MapboxTelemetry)object2);
            }
            return locationCollectionClient;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean uninstall() {
        Object object = lock;
        synchronized (object) {
            LocationCollectionClient locationCollectionClient = LocationCollectionClient.locationCollectionClient;
            if (locationCollectionClient == null) return false;
            locationCollectionClient.locationEngineController.onDestroy();
            LocationCollectionClient.locationCollectionClient.settingsChangeHandlerThread.quit();
            locationCollectionClient = LocationCollectionClient.locationCollectionClient;
            locationCollectionClient.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)locationCollectionClient);
            LocationCollectionClient.locationCollectionClient = null;
            return true;
        }
    }

    String getSessionId() {
        return this.sessionIdentifier.get().getSessionId();
    }

    long getSessionRotationInterval() {
        return this.sessionIdentifier.get().getInterval();
    }

    MapboxTelemetry getTelemetry() {
        return this.telemetry;
    }

    void handleSettingsChangeMessage(Message message) {
        if (message.what == 0) {
            if (this.isEnabled()) {
                this.locationEngineController.onResume();
                this.telemetry.enable();
            } else {
                this.locationEngineController.onDestroy();
                this.telemetry.disable();
            }
        }
    }

    boolean isEnabled() {
        return this.isEnabled.get();
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
        try {
            if ("mapboxTelemetryLocationState".equals(string2)) {
                this.setEnabled(sharedPreferences.getBoolean("mapboxTelemetryLocationState", false));
            } else if ("mapboxSessionRotationInterval".equals(string2)) {
                this.setSessionRotationInterval(sharedPreferences.getLong("mapboxSessionRotationInterval", TimeUnit.HOURS.toMillis(24L)));
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)exception.toString());
        }
    }

    void setEnabled(boolean bl) {
        if (this.isEnabled.compareAndSet(bl ^ true, bl)) {
            this.settingsChangeHandler.sendEmptyMessage(0);
        }
    }

    void setMockHandler(Handler handler) {
        this.settingsChangeHandler = handler;
    }

    void setSessionRotationInterval(long l) {
        this.sessionIdentifier.set(new SessionIdentifier(l));
    }
}

