/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import androidx.core.content.ContextCompat;
import androidx.core.os.BuildCompat;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.telemetry.location.LocationEngineController;
import com.mapbox.android.telemetry.location.LocationUpdatesBroadcastReceiver;

class LocationEngineControllerImpl
implements LocationEngineController {
    private static final long DEFAULT_INTERVAL_IN_MILLISECONDS = 1000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 5000L;
    private static final String TAG = "LocationController";
    private final Context applicationContext;
    private final LocationEngine locationEngine;
    private final LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver;

    LocationEngineControllerImpl(Context context, LocationEngine locationEngine, LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver) {
        this.applicationContext = context;
        this.locationEngine = locationEngine;
        this.locationUpdatesBroadcastReceiver = locationUpdatesBroadcastReceiver;
    }

    private boolean checkPermissions() {
        boolean bl = this.isPermissionGranted("android.permission.ACCESS_FINE_LOCATION") || this.isPermissionGranted("android.permission.ACCESS_COARSE_LOCATION");
        return bl;
    }

    private static LocationEngineRequest createRequest(long l) {
        return new LocationEngineRequest.Builder(l).setPriority(3).setMaxWaitTime(5000L).build();
    }

    private PendingIntent getPendingIntent() {
        Intent intent = new Intent("com.mapbox.android.telemetry.location.locationupdatespendingintent.action.LOCATION_UPDATED");
        int n = BuildCompat.isAtLeastS() ? 0xA000000 : 0x8000000;
        return PendingIntent.getBroadcast((Context)this.applicationContext, (int)0, (Intent)intent, (int)n);
    }

    private boolean isPermissionGranted(String string2) {
        boolean bl = ContextCompat.checkSelfPermission((Context)this.applicationContext, (String)string2) == 0;
        return bl;
    }

    private void registerReceiver() {
        try {
            Context context = this.applicationContext;
            LocationUpdatesBroadcastReceiver locationUpdatesBroadcastReceiver = this.locationUpdatesBroadcastReceiver;
            IntentFilter intentFilter = new IntentFilter("com.mapbox.android.telemetry.location.locationupdatespendingintent.action.LOCATION_UPDATED");
            context.registerReceiver((BroadcastReceiver)locationUpdatesBroadcastReceiver, intentFilter);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)illegalArgumentException.toString());
        }
    }

    private void removeLocationUpdates() {
        this.locationEngine.removeLocationUpdates(this.getPendingIntent());
    }

    private void requestLocationUpdates() {
        if (!this.checkPermissions()) {
            Log.w((String)TAG, (String)"Location permissions are not granted");
            return;
        }
        try {
            this.locationEngine.requestLocationUpdates(LocationEngineControllerImpl.createRequest(1000L), this.getPendingIntent());
        }
        catch (SecurityException securityException) {
            Log.e((String)TAG, (String)securityException.toString());
        }
    }

    private void unregisterReceiver() {
        try {
            this.applicationContext.unregisterReceiver((BroadcastReceiver)this.locationUpdatesBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)illegalArgumentException.toString());
        }
    }

    @Override
    public void onDestroy() {
        this.removeLocationUpdates();
        this.unregisterReceiver();
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onResume() {
        this.registerReceiver();
        this.requestLocationUpdates();
    }
}

