/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import android.location.Location;
import com.mapbox.android.telemetry.LocationEvent;
import com.mapbox.android.telemetry.location.SessionIdentifier;
import java.math.BigDecimal;

public class LocationMapper {
    private static final double MAX_LONGITUDE = 180.0;
    private static final double MIN_LONGITUDE = -180.0;
    private static final int SEVEN_DIGITS_AFTER_DECIMAL = 7;
    private SessionIdentifier sessionIdentifier = new SessionIdentifier();

    private static void addAccuracyIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAccuracy()) {
            locationEvent.setAccuracy(Float.valueOf(Math.round(location.getAccuracy())));
        }
    }

    private static void addAltitudeIfPresent(Location location, LocationEvent locationEvent) {
        if (location.hasAltitude()) {
            locationEvent.setAltitude(Double.valueOf(Math.round(location.getAltitude())));
        }
    }

    @Deprecated
    public static LocationEvent create(Location location, String string2) {
        return LocationMapper.createLocationEvent(location, "unknown", string2);
    }

    public static LocationEvent create(Location location, String string2, String string3) {
        return LocationMapper.createLocationEvent(location, string2, string3);
    }

    private static LocationEvent createLocationEvent(Location location, String object, String string2) {
        object = new LocationEvent(string2, LocationMapper.round(location.getLatitude()), LocationMapper.wrapLongitude(LocationMapper.round(location.getLongitude())), (String)object);
        LocationMapper.addAltitudeIfPresent(location, (LocationEvent)object);
        LocationMapper.addAccuracyIfPresent(location, (LocationEvent)object);
        return object;
    }

    private static double round(double d) {
        return new BigDecimal(d).setScale(7, 1).doubleValue();
    }

    private static double wrap(double d, double d2, double d3) {
        return ((d - d2) % (d3 -= d2) + d3) % d3 + d2;
    }

    private static double wrapLongitude(double d) {
        double d2;
        block3: {
            block2: {
                if (d < -180.0) break block2;
                d2 = d;
                if (!(d > 180.0)) break block3;
            }
            d2 = LocationMapper.wrap(d, -180.0, 180.0);
        }
        return d2;
    }

    public LocationEvent from(Location location, String string2) {
        return LocationMapper.createLocationEvent(location, string2, this.sessionIdentifier.getSessionId());
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }
}

