/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics.network;

import com.mapbox.android.telemetry.metrics.network.NetworkUsageMetricsCollector;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NetworkUsageInterceptor
implements Interceptor {
    private final NetworkUsageMetricsCollector metricsCollector;

    public NetworkUsageInterceptor(NetworkUsageMetricsCollector networkUsageMetricsCollector) {
        this.metricsCollector = networkUsageMetricsCollector;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return chain.proceed(request);
        }
        chain = chain.proceed(request);
        this.metricsCollector.addTxBytes(requestBody.contentLength());
        requestBody = chain.body();
        if (requestBody == null) {
            return chain;
        }
        this.metricsCollector.addRxBytes(requestBody.contentLength());
        return chain;
    }
}

