/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5;

import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.AutoValue_MapboxDirections;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.DirectionsResponseFactory;
import com.mapbox.api.directions.v5.DirectionsService;
import com.mapbox.api.directions.v5.WalkingOptions;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.geojson.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxDirections
extends MapboxService<DirectionsResponse, DirectionsService> {
    protected MapboxDirections() {
        super(DirectionsService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxDirections.Builder().baseUrl("https://api.mapbox.com").profile("driving").user("mapbox").geometries("polyline6");
    }

    private Call<DirectionsResponse> callForUrlLength() {
        Call<DirectionsResponse> call = this.get();
        if (call.request().url().toString().length() < 8192) {
            return call;
        }
        return this.post();
    }

    private Call<DirectionsResponse> get() {
        return ((DirectionsService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), FormatUtils.formatCoordinates(this.coordinates()), this.accessToken(), this.alternatives(), this.geometries(), this.overview(), this.radius(), this.steps(), this.bearing(), this.continueStraight(), this.annotation(), this.language(), this.roundaboutExits(), this.voiceInstructions(), this.bannerInstructions(), this.voiceUnits(), this.exclude(), this.approaches(), this.waypointIndices(), this.waypointNames(), this.waypointTargets(), this.enableRefresh(), this.walkingSpeed(), this.walkwayBias(), this.alleyBias());
    }

    private boolean hasWalkingOptions() {
        boolean bl = this.walkingOptions() != null;
        return bl;
    }

    private Call<DirectionsResponse> post() {
        return ((DirectionsService)this.getService()).postCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), FormatUtils.formatCoordinates(this.coordinates()), this.accessToken(), this.alternatives(), this.geometries(), this.overview(), this.radius(), this.steps(), this.bearing(), this.continueStraight(), this.annotation(), this.language(), this.roundaboutExits(), this.voiceInstructions(), this.bannerInstructions(), this.voiceUnits(), this.exclude(), this.approaches(), this.waypointIndices(), this.waypointNames(), this.waypointTargets(), this.enableRefresh(), this.walkingSpeed(), this.walkwayBias(), this.alleyBias());
    }

    abstract String accessToken();

    Double alleyBias() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().alleyBias();
    }

    abstract Boolean alternatives();

    abstract String annotation();

    abstract String approaches();

    abstract Boolean bannerInstructions();

    @Override
    protected abstract String baseUrl();

    abstract String bearing();

    abstract String clientAppName();

    abstract Boolean continueStraight();

    abstract List<Point> coordinates();

    abstract Boolean enableRefresh();

    @Override
    public void enqueueCall(final Callback<DirectionsResponse> callback) {
        this.getCall().enqueue((Callback)new Callback<DirectionsResponse>(){

            public void onFailure(Call<DirectionsResponse> call, Throwable throwable) {
                callback.onFailure(call, throwable);
            }

            public void onResponse(Call<DirectionsResponse> call, Response<DirectionsResponse> response) {
                response = new DirectionsResponseFactory(MapboxDirections.this).generate(response);
                callback.onResponse(call, response);
            }
        });
    }

    abstract EventListener eventListener();

    abstract String exclude();

    @Override
    public Response<DirectionsResponse> executeCall() throws IOException {
        Response response = super.executeCall();
        return new DirectionsResponseFactory(this).generate(response);
    }

    abstract String geometries();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected OkHttpClient getOkHttpClient() {
        synchronized (this) {
            HttpLoggingInterceptor httpLoggingInterceptor;
            if (this.okHttpClient != null) return this.okHttpClient;
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.isEnableDebug()) {
                httpLoggingInterceptor = new HttpLoggingInterceptor();
                httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                builder.addInterceptor((Interceptor)httpLoggingInterceptor);
            }
            if ((httpLoggingInterceptor = this.interceptor()) != null) {
                builder.addInterceptor((Interceptor)httpLoggingInterceptor);
            }
            if ((httpLoggingInterceptor = this.networkInterceptor()) != null) {
                builder.addNetworkInterceptor((Interceptor)httpLoggingInterceptor);
            }
            if ((httpLoggingInterceptor = this.eventListener()) != null) {
                builder.eventListener((EventListener)httpLoggingInterceptor);
            }
            this.okHttpClient = builder.build();
            return this.okHttpClient;
        }
    }

    @Override
    protected Call<DirectionsResponse> initializeCall() {
        if (this.usePostMethod() == null) {
            return this.callForUrlLength();
        }
        if (this.usePostMethod().booleanValue()) {
            return this.post();
        }
        return this.get();
    }

    abstract Interceptor interceptor();

    abstract String language();

    abstract Interceptor networkInterceptor();

    abstract String overview();

    abstract String profile();

    abstract String radius();

    abstract Boolean roundaboutExits();

    abstract Boolean steps();

    public abstract Builder toBuilder();

    abstract Boolean usePostMethod();

    abstract String user();

    abstract Boolean voiceInstructions();

    abstract String voiceUnits();

    abstract WalkingOptions walkingOptions();

    Double walkingSpeed() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().walkingSpeed();
    }

    Double walkwayBias() {
        if (!this.hasWalkingOptions()) {
            return null;
        }
        return this.walkingOptions().walkwayBias();
    }

    abstract String waypointIndices();

    abstract String waypointNames();

    abstract String waypointTargets();

    public static abstract class Builder {
        private List<String> annotations;
        private List<String> approaches;
        private List<List<Double>> bearings = new ArrayList<List<Double>>();
        private List<Point> coordinates = new ArrayList<Point>();
        private Point destination;
        private Point origin;
        private List<Double> radiuses;
        private List<Integer> waypointIndices;
        private List<String> waypointNames;
        private List<Point> waypointTargets;

        public Builder() {
            this.annotations = new ArrayList<String>();
            this.radiuses = new ArrayList<Double>();
            this.approaches = new ArrayList<String>();
            this.waypointIndices = new ArrayList<Integer>();
            this.waypointNames = new ArrayList<String>();
            this.waypointTargets = new ArrayList<Point>();
        }

        public abstract Builder accessToken(String var1);

        public Builder addAnnotation(String string2) {
            this.annotations.add(string2);
            return this;
        }

        public Builder addApproach(String string2) {
            this.approaches.add(string2);
            return this;
        }

        @Deprecated
        public Builder addApproaches(String ... stringArray) {
            return this.approaches(Arrays.asList(stringArray));
        }

        public Builder addBearing(Double d, Double d2) {
            this.bearings.add(Arrays.asList(d, d2));
            return this;
        }

        public Builder addRadius(Double d) {
            this.radiuses.add(d);
            return this;
        }

        public Builder addWaypoint(Point point) {
            this.coordinates.add(point);
            return this;
        }

        public Builder addWaypointIndex(Integer n) {
            this.waypointIndices.add(n);
            return this;
        }

        @Deprecated
        public Builder addWaypointIndices(Integer ... integerArray) {
            return this.waypointIndices(Arrays.asList(integerArray));
        }

        public Builder addWaypointName(String string2) {
            this.waypointNames.add(string2);
            return this;
        }

        @Deprecated
        public Builder addWaypointNames(String ... stringArray) {
            return this.waypointNames(Arrays.asList(stringArray));
        }

        public Builder addWaypointTarget(Point point) {
            this.waypointTargets.add(point);
            return this;
        }

        @Deprecated
        public Builder addWaypointTargets(Point ... pointArray) {
            return this.waypointTargets(Arrays.asList(pointArray));
        }

        public abstract Builder alternatives(Boolean var1);

        abstract Builder annotation(String var1);

        public Builder annotations(List<String> list) {
            this.annotations = list;
            return this;
        }

        @Deprecated
        public Builder annotations(String ... stringArray) {
            return this.annotations(Arrays.asList(stringArray));
        }

        abstract Builder approaches(String var1);

        public Builder approaches(List<String> list) {
            this.approaches = list;
            return this;
        }

        abstract MapboxDirections autoBuild();

        public abstract Builder bannerInstructions(Boolean var1);

        public abstract Builder baseUrl(String var1);

        abstract Builder bearing(String var1);

        public Builder bearings(List<List<Double>> list) {
            this.bearings = list;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MapboxDirections build() {
            Object object = this.origin;
            if (object != null) {
                this.coordinates.add(0, (Point)object);
            }
            if ((object = this.destination) != null) {
                this.coordinates.add((Point)object);
            }
            if (this.coordinates.size() < 2) throw new ServicesException("An origin and destination are required before making the directions API request.");
            if (!this.waypointIndices.isEmpty()) {
                if (this.waypointIndices.size() < 2) throw new ServicesException("Waypoints must be a list of at least two indexes separated by ';'");
                if (this.waypointIndices.get(0) != 0 || (Integer)(object = this.waypointIndices).get(object.size() - 1) != this.coordinates.size() - 1) throw new ServicesException("Waypoints must contain indices of the first and last coordinates");
                for (int i = 1; i < this.waypointIndices.size() - 1; ++i) {
                    if (this.waypointIndices.get(i) < 0 || this.waypointIndices.get(i) >= this.coordinates.size()) throw new ServicesException("Waypoints index too large (no corresponding coordinate)");
                }
            }
            if (!this.waypointNames.isEmpty()) {
                this.waypointNames(FormatUtils.formatWaypointNames(this.waypointNames));
            }
            if (!this.waypointTargets.isEmpty()) {
                if (this.waypointTargets.size() != this.coordinates.size()) throw new ServicesException("Number of waypoint targets must match  the number of waypoints provided.");
                this.waypointTargets(FormatUtils.formatPointsList(this.waypointTargets));
            }
            if (!this.approaches.isEmpty()) {
                if (this.approaches.size() != this.coordinates.size()) throw new ServicesException("Number of approach elements must match number of coordinates provided.");
                object = FormatUtils.formatApproaches(this.approaches);
                if (object == null) throw new ServicesException("All approaches values must be one of curb, unrestricted");
                this.approaches((String)object);
            }
            this.coordinates(this.coordinates);
            this.bearing(FormatUtils.formatBearings(this.bearings));
            this.annotation(FormatUtils.join(",", this.annotations));
            this.radius(FormatUtils.formatRadiuses(this.radiuses));
            this.waypointIndices(FormatUtils.join(";", this.waypointIndices, true));
            object = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid(((MapboxDirections)object).accessToken())) throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            return object;
        }

        public abstract Builder clientAppName(String var1);

        public abstract Builder continueStraight(Boolean var1);

        abstract Builder coordinates(List<Point> var1);

        public Builder destination(Point point) {
            this.destination = point;
            return this;
        }

        public abstract Builder enableRefresh(Boolean var1);

        public abstract Builder eventListener(EventListener var1);

        public abstract Builder exclude(String var1);

        public abstract Builder geometries(String var1);

        public Builder get() {
            this.usePostMethod(false);
            return this;
        }

        public abstract Builder interceptor(Interceptor var1);

        abstract Builder language(String var1);

        public Builder language(Locale locale) {
            if (locale != null) {
                this.language(locale.getLanguage());
            }
            return this;
        }

        public abstract Builder networkInterceptor(Interceptor var1);

        public Builder origin(Point point) {
            this.origin = point;
            return this;
        }

        public abstract Builder overview(String var1);

        public Builder post() {
            this.usePostMethod(true);
            return this;
        }

        public abstract Builder profile(String var1);

        abstract Builder radius(String var1);

        public Builder radiuses(List<Double> list) {
            this.radiuses = list;
            return this;
        }

        @Deprecated
        public Builder radiuses(Double ... doubleArray) {
            return this.radiuses(Arrays.asList(doubleArray));
        }

        public abstract Builder roundaboutExits(Boolean var1);

        public abstract Builder steps(Boolean var1);

        abstract Builder usePostMethod(Boolean var1);

        abstract Boolean usePostMethod();

        public abstract Builder user(String var1);

        public abstract Builder voiceInstructions(Boolean var1);

        public abstract Builder voiceUnits(String var1);

        public abstract Builder walkingOptions(WalkingOptions var1);

        abstract WalkingOptions walkingOptions();

        abstract Builder waypointIndices(String var1);

        public Builder waypointIndices(List<Integer> list) {
            this.waypointIndices = list;
            return this;
        }

        abstract Builder waypointNames(String var1);

        public Builder waypointNames(List<String> list) {
            this.waypointNames = list;
            return this;
        }

        abstract Builder waypointTargets(String var1);

        public Builder waypointTargets(List<Point> list) {
            this.waypointTargets = list;
            return this;
        }

        public Builder waypoints(List<Point> list) {
            this.coordinates = list;
            return this;
        }
    }
}

