/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.WalkingOptions;
import com.mapbox.api.directions.v5.WalkingOptionsAdapterFactory;
import com.mapbox.api.directions.v5.models.;
import com.mapbox.api.directions.v5.models.AutoValue_RouteOptions;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.directions.v5.utils.ParseUtils;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.PointAsCoordinatesTypeAdapter;
import java.lang.reflect.Type;
import java.util.List;

public abstract class RouteOptions
extends DirectionsJsonObject {
    public static Builder builder() {
        return new .AutoValue_RouteOptions.Builder();
    }

    public static RouteOptions fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        gsonBuilder.registerTypeAdapter((Type)((Object)Point.class), new PointAsCoordinatesTypeAdapter());
        gsonBuilder.registerTypeAdapterFactory(WalkingOptionsAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, RouteOptions.class);
    }

    public static TypeAdapter<RouteOptions> typeAdapter(Gson gson) {
        return new AutoValue_RouteOptions.GsonTypeAdapter(gson);
    }

    @SerializedName(value="access_token")
    public abstract String accessToken();

    public abstract Boolean alternatives();

    public abstract String annotations();

    public List<String> annotationsList() {
        return ParseUtils.parseToStrings(this.annotations(), ",");
    }

    public abstract String approaches();

    public List<String> approachesList() {
        return ParseUtils.parseToStrings(this.approaches());
    }

    @SerializedName(value="banner_instructions")
    public abstract Boolean bannerInstructions();

    public abstract String baseUrl();

    public abstract String bearings();

    public List<List<Double>> bearingsList() {
        return ParseUtils.parseToListOfListOfDoubles(this.bearings());
    }

    @SerializedName(value="continue_straight")
    public abstract Boolean continueStraight();

    public abstract List<Point> coordinates();

    public abstract String exclude();

    public abstract String geometries();

    public abstract String language();

    public abstract String overview();

    public abstract String profile();

    public abstract String radiuses();

    public List<Double> radiusesList() {
        return ParseUtils.parseToDoubles(this.radiuses());
    }

    @SerializedName(value="uuid")
    public abstract String requestUuid();

    @SerializedName(value="roundabout_exits")
    public abstract Boolean roundaboutExits();

    public abstract Boolean steps();

    public abstract Builder toBuilder();

    public abstract String user();

    @SerializedName(value="voice_instructions")
    public abstract Boolean voiceInstructions();

    @SerializedName(value="voice_units")
    public abstract String voiceUnits();

    public abstract WalkingOptions walkingOptions();

    @SerializedName(value="waypoints")
    public abstract String waypointIndices();

    public List<Integer> waypointIndicesList() {
        return ParseUtils.parseToIntegers(this.waypointIndices());
    }

    @SerializedName(value="waypoint_names")
    public abstract String waypointNames();

    public List<String> waypointNamesList() {
        return ParseUtils.parseToStrings(this.waypointNames());
    }

    @SerializedName(value="waypoint_targets")
    public abstract String waypointTargets();

    public List<Point> waypointTargetsList() {
        return ParseUtils.parseToPoints(this.waypointTargets());
    }

    public static abstract class Builder {
        public abstract Builder accessToken(String var1);

        public abstract Builder alternatives(Boolean var1);

        public abstract Builder annotations(String var1);

        public Builder annotationsList(List<String> object) {
            if ((object = FormatUtils.join(",", object)) != null) {
                this.annotations((String)object);
            }
            return this;
        }

        public abstract Builder approaches(String var1);

        public Builder approachesList(List<String> object) {
            if ((object = FormatUtils.formatApproaches(object)) != null) {
                this.approaches((String)object);
            }
            return this;
        }

        public abstract Builder bannerInstructions(Boolean var1);

        public abstract Builder baseUrl(String var1);

        public abstract Builder bearings(String var1);

        public Builder bearingsList(List<List<Double>> object) {
            if ((object = FormatUtils.formatBearings(object)) != null) {
                this.bearings((String)object);
            }
            return this;
        }

        public abstract RouteOptions build();

        public abstract Builder continueStraight(Boolean var1);

        public abstract Builder coordinates(List<Point> var1);

        public abstract Builder exclude(String var1);

        public abstract Builder geometries(String var1);

        public abstract Builder language(String var1);

        public abstract Builder overview(String var1);

        public abstract Builder profile(String var1);

        public abstract Builder radiuses(String var1);

        public Builder radiusesList(List<Double> object) {
            if ((object = FormatUtils.formatRadiuses(object)) != null) {
                this.radiuses((String)object);
            }
            return this;
        }

        public abstract Builder requestUuid(String var1);

        public abstract Builder roundaboutExits(Boolean var1);

        public abstract Builder steps(Boolean var1);

        public abstract Builder user(String var1);

        public abstract Builder voiceInstructions(Boolean var1);

        public abstract Builder voiceUnits(String var1);

        public abstract Builder walkingOptions(WalkingOptions var1);

        public abstract Builder waypointIndices(String var1);

        public Builder waypointIndicesList(List<Integer> object) {
            if ((object = FormatUtils.join(";", object)) != null) {
                this.waypointIndices((String)object);
            }
            return this;
        }

        public abstract Builder waypointNames(String var1);

        public Builder waypointNamesList(List<String> object) {
            if ((object = FormatUtils.formatWaypointNames(object)) != null) {
                this.waypointNames((String)object);
            }
            return this;
        }

        public abstract Builder waypointTargets(String var1);

        public Builder waypointTargetsList(List<Point> list) {
            this.waypointTargets(FormatUtils.formatPointsList(list));
            return this;
        }
    }
}

