/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.geocoding.v5;

import com.google.gson.GsonBuilder;
import com.mapbox.api.geocoding.v5.AutoValue_MapboxGeocoding;
import com.mapbox.api.geocoding.v5.GeocodingService;
import com.mapbox.api.geocoding.v5.SingleElementSafeListTypeAdapter;
import com.mapbox.api.geocoding.v5.models.GeocodingAdapterFactory;
import com.mapbox.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxGeocoding
extends MapboxService<GeocodingResponse, GeocodingService> {
    private Call<List<GeocodingResponse>> batchCall;

    protected MapboxGeocoding() {
        super(GeocodingService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxGeocoding.Builder().baseUrl("https://api.mapbox.com").mode("mapbox.places");
    }

    private Call<List<GeocodingResponse>> getBatchCall() {
        Call<List<GeocodingResponse>> call = this.batchCall;
        if (call != null) {
            return call;
        }
        if (!this.mode().equals("mapbox.places")) {
            this.batchCall = call = ((GeocodingService)this.getService()).getBatchCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.mode(), this.query(), this.accessToken(), this.country(), this.proximity(), this.geocodingTypes(), this.autocomplete(), this.bbox(), this.limit(), this.languages(), this.reverseMode(), this.fuzzyMatch());
            return call;
        }
        throw new ServicesException("Use getCall() for non-batch calls or set the mode to `permanent` for batch requests.");
    }

    abstract String accessToken();

    abstract Boolean autocomplete();

    @Override
    protected abstract String baseUrl();

    abstract String bbox();

    public void cancelBatchCall() {
        this.getBatchCall().cancel();
    }

    abstract String clientAppName();

    public Call<List<GeocodingResponse>> cloneBatchCall() {
        return this.getBatchCall().clone();
    }

    abstract String country();

    public void enqueueBatchCall(Callback<List<GeocodingResponse>> callback) {
        this.getBatchCall().enqueue(callback);
    }

    public Response<List<GeocodingResponse>> executeBatchCall() throws IOException {
        return this.getBatchCall().execute();
    }

    abstract Boolean fuzzyMatch();

    abstract String geocodingTypes();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeocodingAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapterFactory(SingleElementSafeListTypeAdapter.FACTORY).registerTypeAdapter((Type)((Object)BoundingBox.class), new BoundingBoxTypeAdapter());
    }

    @Override
    protected Call<GeocodingResponse> initializeCall() {
        if (!this.mode().contains("mapbox.places-permanent")) {
            return ((GeocodingService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.mode(), this.query(), this.accessToken(), this.country(), this.proximity(), this.geocodingTypes(), this.autocomplete(), this.bbox(), this.limit(), this.languages(), this.reverseMode(), this.fuzzyMatch());
        }
        throw new IllegalArgumentException("Use getBatchCall() for batch calls.");
    }

    abstract String languages();

    abstract String limit();

    abstract String mode();

    abstract String proximity();

    abstract String query();

    abstract String reverseMode();

    public static abstract class Builder {
        private List<String> countries = new ArrayList<String>();
        private List<String> intersectionStreets = new ArrayList<String>();

        public abstract Builder accessToken(String var1);

        abstract MapboxGeocoding autoBuild();

        public abstract Builder autocomplete(Boolean var1);

        public abstract Builder baseUrl(String var1);

        public Builder bbox(double d, double d2, double d3, double d4) {
            this.bbox(String.format(Locale.US, "%s,%s,%s,%s", TextUtils.formatCoordinate(d), TextUtils.formatCoordinate(d2), TextUtils.formatCoordinate(d3), TextUtils.formatCoordinate(d4)));
            return this;
        }

        public Builder bbox(BoundingBox boundingBox) {
            this.bbox(boundingBox.southwest().longitude(), boundingBox.southwest().latitude(), boundingBox.northeast().longitude(), boundingBox.northeast().latitude());
            return this;
        }

        public Builder bbox(Point point, Point point2) {
            this.bbox(point.longitude(), point.latitude(), point2.longitude(), point2.latitude());
            return this;
        }

        public abstract Builder bbox(String var1);

        public MapboxGeocoding build() {
            MapboxGeocoding mapboxGeocoding;
            if (!this.countries.isEmpty()) {
                this.country(TextUtils.join(",", this.countries.toArray()));
            }
            if (this.intersectionStreets.size() == 2) {
                this.query(TextUtils.join(" and ", this.intersectionStreets.toArray()));
                this.geocodingTypes("address");
            }
            if (MapboxUtils.isAccessTokenValid((mapboxGeocoding = this.autoBuild()).accessToken())) {
                if (!mapboxGeocoding.query().isEmpty()) {
                    if (mapboxGeocoding.reverseMode() != null && mapboxGeocoding.limit() != null && !mapboxGeocoding.limit().equals("1")) {
                        throw new ServicesException("Limit must be combined with a single type parameter");
                    }
                    if (this.intersectionStreets.size() == 2) {
                        if (!mapboxGeocoding.mode().equals("mapbox.places") && !mapboxGeocoding.mode().equals("mapbox.places-permanent")) {
                            throw new ServicesException("Geocoding mode must be GeocodingCriteria.MODE_PLACES or GeocodingCriteria.MODE_PLACES_PERMANENT for intersection search.");
                        }
                        if (!TextUtils.isEmpty(mapboxGeocoding.geocodingTypes()) && mapboxGeocoding.geocodingTypes().equals("address")) {
                            if (TextUtils.isEmpty(mapboxGeocoding.proximity())) {
                                throw new ServicesException("Geocoding proximity must be set for intersection search.");
                            }
                        } else {
                            throw new ServicesException("Geocoding type must be set to Geocoding Criteria.TYPE_ADDRESS for intersection search.");
                        }
                    }
                    return mapboxGeocoding;
                }
                throw new ServicesException("A query with at least one character or digit is required.");
            }
            throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
        }

        public abstract Builder clientAppName(String var1);

        public abstract Builder country(String var1);

        public Builder country(Locale locale) {
            this.countries.add(locale.getCountry());
            return this;
        }

        public Builder country(String ... stringArray) {
            this.countries.addAll(Arrays.asList(stringArray));
            return this;
        }

        public abstract Builder fuzzyMatch(Boolean var1);

        abstract Builder geocodingTypes(String var1);

        public Builder geocodingTypes(String ... stringArray) {
            this.geocodingTypes(TextUtils.join(",", stringArray));
            return this;
        }

        public Builder intersectionStreets(String string2, String string3) {
            this.intersectionStreets.add(string2);
            this.intersectionStreets.add(string3);
            return this;
        }

        public abstract Builder languages(String var1);

        public Builder languages(Locale ... localeArray) {
            Object[] objectArray = new String[localeArray.length];
            for (int i = 0; i < localeArray.length; ++i) {
                objectArray[i] = localeArray[i].getLanguage();
            }
            this.languages(TextUtils.join(",", objectArray));
            return this;
        }

        public Builder limit(int n) {
            this.limit(String.valueOf(n));
            return this;
        }

        abstract Builder limit(String var1);

        public abstract Builder mode(String var1);

        public Builder proximity(Point point) {
            this.proximity(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(point.longitude()), point.latitude()));
            return this;
        }

        abstract Builder proximity(String var1);

        public Builder query(Point point) {
            this.query(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(point.longitude()), TextUtils.formatCoordinate(point.latitude())));
            return this;
        }

        public abstract Builder query(String var1);

        public abstract Builder reverseMode(String var1);
    }
}

