/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.geocoding.v5.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.geocoding.v5.models.;
import com.mapbox.api.geocoding.v5.models.AutoValue_CarmenFeature;
import com.mapbox.api.geocoding.v5.models.CarmenContext;
import com.mapbox.api.geocoding.v5.models.GeocodingAdapterFactory;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import java.lang.reflect.Type;
import java.util.List;

public abstract class CarmenFeature
implements GeoJson {
    private static final String TYPE = "Feature";

    public static Builder builder() {
        return new .AutoValue_CarmenFeature.Builder().type(TYPE).properties(new JsonObject());
    }

    public static CarmenFeature fromJson(String object) {
        CarmenFeature carmenFeature = new GsonBuilder().registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapter((Type)((Object)BoundingBox.class), new BoundingBoxTypeAdapter()).registerTypeAdapterFactory(GeocodingAdapterFactory.create()).create().fromJson((String)object, CarmenFeature.class);
        object = carmenFeature;
        if (carmenFeature.properties() == null) {
            object = carmenFeature.toBuilder().properties(new JsonObject()).build();
        }
        return object;
    }

    public static TypeAdapter<CarmenFeature> typeAdapter(Gson gson) {
        return new AutoValue_CarmenFeature.GsonTypeAdapter(gson);
    }

    public abstract String address();

    @Override
    public abstract BoundingBox bbox();

    public Point center() {
        double[] dArray = this.rawCenter();
        if (dArray != null && dArray.length == 2) {
            return Point.fromLngLat(dArray[0], dArray[1]);
        }
        return null;
    }

    public abstract List<CarmenContext> context();

    public abstract Geometry geometry();

    public abstract String id();

    public abstract String language();

    @SerializedName(value="matching_place_name")
    public abstract String matchingPlaceName();

    @SerializedName(value="matching_text")
    public abstract String matchingText();

    @SerializedName(value="place_name")
    public abstract String placeName();

    @SerializedName(value="place_type")
    public abstract List<String> placeType();

    public abstract JsonObject properties();

    @SerializedName(value="center")
    abstract double[] rawCenter();

    public abstract Double relevance();

    public abstract String text();

    public abstract Builder toBuilder();

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapter((Type)((Object)BoundingBox.class), new BoundingBoxTypeAdapter()).registerTypeAdapterFactory(GeocodingAdapterFactory.create()).create();
        CarmenFeature carmenFeature = this.properties() != null && this.properties().size() == 0 ? this.toBuilder().properties(null).build() : this;
        return gson.toJson((Object)carmenFeature, (Type)((Object)CarmenFeature.class));
    }

    @Override
    @SerializedName(value="type")
    public abstract String type();

    public static abstract class Builder {
        public abstract Builder address(String var1);

        public abstract Builder bbox(BoundingBox var1);

        public abstract CarmenFeature build();

        public abstract Builder context(List<CarmenContext> var1);

        public abstract Builder geometry(Geometry var1);

        public abstract Builder id(String var1);

        public abstract Builder language(String var1);

        public abstract Builder matchingPlaceName(String var1);

        public abstract Builder matchingText(String var1);

        public abstract Builder placeName(String var1);

        public abstract Builder placeType(List<String> var1);

        public abstract Builder properties(JsonObject var1);

        public abstract Builder rawCenter(double[] var1);

        public abstract Builder relevance(Double var1);

        public abstract Builder text(String var1);

        abstract Builder type(String var1);
    }
}

