/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.isochrone;

import com.google.gson.GsonBuilder;
import com.mapbox.api.isochrone.AutoValue_MapboxIsochrone;
import com.mapbox.api.isochrone.IsochroneService;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.util.Locale;
import retrofit2.Call;

public abstract class MapboxIsochrone
extends MapboxService<FeatureCollection, IsochroneService> {
    protected MapboxIsochrone() {
        super(IsochroneService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxIsochrone.Builder().baseUrl("https://api.mapbox.com").user("mapbox");
    }

    abstract String accessToken();

    @Override
    protected abstract String baseUrl();

    abstract String contoursColors();

    abstract String contoursMinutes();

    abstract String coordinates();

    abstract Float denoise();

    abstract Float generalize();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create());
    }

    @Override
    protected Call<FeatureCollection> initializeCall() {
        return ((IsochroneService)this.getService()).getCall(this.user(), this.profile(), this.coordinates(), this.contoursMinutes(), this.accessToken(), this.contoursColors(), this.polygons(), this.denoise(), this.generalize());
    }

    abstract Boolean polygons();

    abstract String profile();

    abstract String user();

    public static abstract class Builder {
        private String[] contoursColors;
        private Integer[] contoursMinutes;

        public abstract Builder accessToken(String var1);

        public Builder addContoursColors(String ... stringArray) {
            this.contoursColors = stringArray;
            return this;
        }

        public Builder addContoursMinutes(Integer ... integerArray) {
            this.contoursMinutes = integerArray;
            return this;
        }

        abstract MapboxIsochrone autoBuild();

        public abstract Builder baseUrl(String var1);

        public MapboxIsochrone build() {
            Integer[] integerArray;
            Object object = this.contoursMinutes;
            if (object != null) {
                if (((Integer[])object).length >= 1) {
                    if (((Object[])object).length >= 2) {
                        int n = 0;
                        while (n < ((Object)(object = this.contoursMinutes)).length - 1) {
                            int n2 = (Integer)object[n];
                            if (n2 <= (Integer)(object = this.contoursMinutes)[++n]) continue;
                            throw new ServicesException("The minutes must be listed in order from the lowest number to the highest number.");
                        }
                    }
                    this.contoursMinutes(TextUtils.join(",", this.contoursMinutes));
                } else {
                    throw new ServicesException("A query with at least one specified minute amount is required.");
                }
            }
            if ((object = this.contoursColors) != null) {
                this.contoursColors(TextUtils.join(",", (Object[])object));
            }
            if ((object = this.contoursColors) != null && (integerArray = this.contoursMinutes) != null && ((Object)object).length != integerArray.length) {
                throw new ServicesException("Number of color elements must match number of minute elements provided.");
            }
            object = this.autoBuild();
            if (MapboxUtils.isAccessTokenValid(((MapboxIsochrone)object).accessToken())) {
                if (!TextUtils.isEmpty(((MapboxIsochrone)object).coordinates())) {
                    if (!TextUtils.isEmpty(((MapboxIsochrone)object).profile())) {
                        if (!TextUtils.isEmpty(((MapboxIsochrone)object).contoursMinutes())) {
                            if (((MapboxIsochrone)object).contoursColors() != null && ((MapboxIsochrone)object).contoursColors().contains("#")) {
                                throw new ServicesException("Make sure that none of the contour color HEX values have a # in front of it. Provide a list of the HEX values without any # symbols.");
                            }
                            return object;
                        }
                        throw new ServicesException("A query with at least one specified minute amount is required.");
                    }
                    throw new ServicesException("A query with a set Directions profile (cycling, walking, or driving) is required.");
                }
                throw new ServicesException("A query with longitude and latitude values is required.");
            }
            throw new ServicesException("Using the Mapbox Isochrone API requires setting a valid access token.");
        }

        abstract Builder contoursColors(String var1);

        abstract Builder contoursMinutes(String var1);

        public Builder coordinates(Point point) {
            this.coordinates(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(point.longitude()), TextUtils.formatCoordinate(point.latitude())));
            return this;
        }

        public abstract Builder coordinates(String var1);

        public abstract Builder denoise(Float var1);

        public abstract Builder generalize(Float var1);

        public abstract Builder polygons(Boolean var1);

        public abstract Builder profile(String var1);

        public abstract Builder user(String var1);
    }
}

