/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matching.v5;

import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.matching.v5.AutoValue_MapboxMapMatching;
import com.mapbox.api.matching.v5.MapMatchingService;
import com.mapbox.api.matching.v5.MatchingResponseFactory;
import com.mapbox.api.matching.v5.models.MapMatchingAdapterFactory;
import com.mapbox.api.matching.v5.models.MapMatchingResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxMapMatching
extends MapboxService<MapMatchingResponse, MapMatchingService> {
    protected MapboxMapMatching() {
        super(MapMatchingService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxMapMatching.Builder().baseUrl("https://api.mapbox.com").profile("driving").geometries("polyline6").user("mapbox");
    }

    private Call<MapMatchingResponse> callForUrlLength() {
        Call<MapMatchingResponse> call = this.get();
        if (call.request().url().toString().length() < 8192) {
            return call;
        }
        return this.post();
    }

    private Call<MapMatchingResponse> get() {
        return ((MapMatchingService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.geometries(), this.radiuses(), this.steps(), this.overview(), this.timestamps(), this.annotations(), this.language(), this.tidy(), this.roundaboutExits(), this.bannerInstructions(), this.voiceInstructions(), this.voiceUnits(), this.waypointIndices(), this.waypointNames(), this.approaches());
    }

    private Call<MapMatchingResponse> post() {
        return ((MapMatchingService)this.getService()).postCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.geometries(), this.radiuses(), this.steps(), this.overview(), this.timestamps(), this.annotations(), this.language(), this.tidy(), this.roundaboutExits(), this.bannerInstructions(), this.voiceInstructions(), this.voiceUnits(), this.waypointIndices(), this.waypointNames(), this.approaches());
    }

    abstract String accessToken();

    abstract String annotations();

    abstract String approaches();

    abstract Boolean bannerInstructions();

    @Override
    protected abstract String baseUrl();

    abstract String clientAppName();

    abstract String coordinates();

    @Override
    public void enqueueCall(final Callback<MapMatchingResponse> callback) {
        this.getCall().enqueue((Callback)new Callback<MapMatchingResponse>(){

            public void onFailure(Call<MapMatchingResponse> call, Throwable throwable) {
                callback.onFailure(call, throwable);
            }

            public void onResponse(Call<MapMatchingResponse> call, Response<MapMatchingResponse> response) {
                response = new MatchingResponseFactory(MapboxMapMatching.this).generate(response);
                callback.onResponse(call, response);
            }
        });
    }

    @Override
    public Response<MapMatchingResponse> executeCall() throws IOException {
        Response response = this.getCall().execute();
        return new MatchingResponseFactory(this).generate((Response<MapMatchingResponse>)response);
    }

    abstract String geometries();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(MapMatchingAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    @Override
    protected Call<MapMatchingResponse> initializeCall() {
        if (this.usePostMethod() == null) {
            return this.callForUrlLength();
        }
        if (this.usePostMethod().booleanValue()) {
            return this.post();
        }
        return this.get();
    }

    abstract String language();

    abstract String overview();

    abstract String profile();

    abstract String radiuses();

    abstract Boolean roundaboutExits();

    abstract Boolean steps();

    abstract Boolean tidy();

    abstract String timestamps();

    abstract Boolean usePostMethod();

    abstract String user();

    abstract Boolean voiceInstructions();

    abstract String voiceUnits();

    abstract String waypointIndices();

    abstract String waypointNames();

    public static abstract class Builder {
        private String[] annotations;
        private String[] approaches;
        private List<Point> coordinates = new ArrayList<Point>();
        private Double[] radiuses;
        private String[] timestamps;
        private Integer[] waypointIndices;
        private String[] waypointNames;

        private static String formatCoordinates(List<Point> object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Point point = (Point)object.next();
                arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(point.longitude()), FormatUtils.formatCoordinate(point.latitude())));
            }
            return TextUtils.join(";", arrayList.toArray());
        }

        public abstract Builder accessToken(String var1);

        public Builder addApproaches(String ... stringArray) {
            this.approaches = stringArray;
            return this;
        }

        public Builder addWaypointNames(String ... stringArray) {
            this.waypointNames = stringArray;
            return this;
        }

        protected abstract Builder annotations(String var1);

        public Builder annotations(String ... stringArray) {
            this.annotations = stringArray;
            return this;
        }

        abstract Builder approaches(String var1);

        protected abstract MapboxMapMatching autoBuild();

        public abstract Builder bannerInstructions(Boolean var1);

        public abstract Builder baseUrl(String var1);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MapboxMapMatching build() {
            Object object = this.coordinates;
            if (object == null || object.size() < 2) throw new ServicesException("At least two coordinates must be provided with your API request.");
            object = this.radiuses;
            if (object != null && ((Double[])object).length != this.coordinates.size()) {
                throw new ServicesException("There must be as many radiuses as there are coordinates.");
            }
            object = this.timestamps;
            if (object != null && ((Object[])object).length != this.coordinates.size()) {
                throw new ServicesException("There must be as many timestamps as there are coordinates.");
            }
            object = this.waypointIndices;
            if (object != null) {
                if (((Object[])object).length < 2) throw new ServicesException("Waypoints must be a list of at least two indexes separated by ';'");
                if ((Integer)object[0] != 0 || (Integer)(object = this.waypointIndices)[((Object[])object).length - 1] != this.coordinates.size() - 1) throw new ServicesException("Waypoints must contain indices of the first and last coordinates");
                for (int i = 1; i < ((Object[])(object = this.waypointIndices)).length - 1; ++i) {
                    if ((Integer)object[i] < 0 || this.waypointIndices[i] >= this.coordinates.size()) throw new ServicesException("Waypoints index too large (no corresponding coordinate)");
                }
            }
            if ((object = this.waypointNames) != null) {
                this.waypointNames(FormatUtils.formatWaypointNames(Arrays.asList(object)));
            }
            if ((object = this.approaches) != null) {
                if (((Object[])object).length != this.coordinates.size()) throw new ServicesException("Number of approach elements must match number of coordinates provided.");
                object = FormatUtils.formatApproaches(Arrays.asList(this.approaches));
                if (object == null) throw new ServicesException("All approaches values must be one of curb, unrestricted");
                this.approaches((String)object);
            }
            this.coordinates(Builder.formatCoordinates(this.coordinates));
            this.timestamps(TextUtils.join(";", this.timestamps));
            this.annotations(TextUtils.join(",", this.annotations));
            this.radiuses(TextUtils.join(";", this.radiuses));
            this.waypointIndices(TextUtils.join(";", this.waypointIndices));
            object = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid(((MapboxMapMatching)object).accessToken())) throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            return object;
        }

        public abstract Builder clientAppName(String var1);

        public Builder coordinate(Point point) {
            this.coordinates.add(point);
            return this;
        }

        protected abstract Builder coordinates(String var1);

        public Builder coordinates(List<Point> list) {
            this.coordinates.addAll(list);
            return this;
        }

        public abstract Builder geometries(String var1);

        public Builder get() {
            this.usePostMethod(false);
            return this;
        }

        public abstract Builder language(String var1);

        public Builder language(Locale locale) {
            if (locale != null) {
                this.language(locale.getLanguage());
            }
            return this;
        }

        public abstract Builder overview(String var1);

        public Builder post() {
            this.usePostMethod(true);
            return this;
        }

        public abstract Builder profile(String var1);

        abstract Builder radiuses(String var1);

        public Builder radiuses(Double ... doubleArray) {
            this.radiuses = doubleArray;
            return this;
        }

        public abstract Builder roundaboutExits(Boolean var1);

        public abstract Builder steps(Boolean var1);

        public abstract Builder tidy(Boolean var1);

        protected abstract Builder timestamps(String var1);

        public Builder timestamps(String ... stringArray) {
            this.timestamps = stringArray;
            return this;
        }

        abstract Builder usePostMethod(Boolean var1);

        public abstract Builder user(String var1);

        public abstract Builder voiceInstructions(Boolean var1);

        public abstract Builder voiceUnits(String var1);

        abstract Builder waypointIndices(String var1);

        public Builder waypointIndices(Integer ... integerArray) {
            this.waypointIndices = integerArray;
            return this;
        }

        abstract Builder waypointNames(String var1);

        @Deprecated
        public Builder waypoints(Integer ... integerArray) {
            this.waypointIndices = integerArray;
            return this;
        }
    }
}

