/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matching.v5;

import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.directions.v5.utils.ParseUtils;
import com.mapbox.api.matching.v5.MapboxMapMatching;
import com.mapbox.api.matching.v5.models.MapMatchingMatching;
import com.mapbox.api.matching.v5.models.MapMatchingResponse;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

class MatchingResponseFactory {
    private static final String PLACEHOLDER_UUID = "mapmatching";
    private final MapboxMapMatching mapboxMapMatching;

    MatchingResponseFactory(MapboxMapMatching mapboxMapMatching) {
        this.mapboxMapMatching = mapboxMapMatching;
    }

    private static List<Point> formatCoordinates(String stringArray) {
        String[] stringArray2 = stringArray.split(";", -1);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            stringArray = stringArray2[i].split(",", -1);
            arrayList.add(Point.fromLngLat(Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1])));
        }
        return arrayList;
    }

    private List<MapMatchingMatching> generateRouteOptions(retrofit2.Response<MapMatchingResponse> object) {
        Object object2 = ((MapMatchingResponse)object.body()).matchings();
        object = new ArrayList();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object.add((MapMatchingMatching)((MapMatchingMatching)object2.next()).toBuilder().routeOptions(RouteOptions.builder().profile(this.mapboxMapMatching.profile()).coordinates(MatchingResponseFactory.formatCoordinates(this.mapboxMapMatching.coordinates())).annotations(this.mapboxMapMatching.annotations()).approachesList(ParseUtils.parseToStrings(this.mapboxMapMatching.approaches())).language(this.mapboxMapMatching.language()).radiusesList(ParseUtils.parseToDoubles(this.mapboxMapMatching.radiuses())).user(this.mapboxMapMatching.user()).voiceInstructions(this.mapboxMapMatching.voiceInstructions()).bannerInstructions(this.mapboxMapMatching.bannerInstructions()).roundaboutExits(this.mapboxMapMatching.roundaboutExits()).geometries(this.mapboxMapMatching.geometries()).overview(this.mapboxMapMatching.overview()).steps(this.mapboxMapMatching.steps()).voiceUnits(this.mapboxMapMatching.voiceUnits()).requestUuid(PLACEHOLDER_UUID).accessToken(this.mapboxMapMatching.accessToken()).waypointIndicesList(ParseUtils.parseToIntegers(this.mapboxMapMatching.waypointIndices())).waypointNamesList(ParseUtils.parseToStrings(this.mapboxMapMatching.waypointNames())).baseUrl(this.mapboxMapMatching.baseUrl()).build()).build());
        }
        return object;
    }

    private boolean isNotSuccessful(retrofit2.Response<MapMatchingResponse> response) {
        boolean bl = !response.isSuccessful() || response.body() == null || ((MapMatchingResponse)response.body()).matchings() == null || ((MapMatchingResponse)response.body()).matchings().isEmpty();
        return bl;
    }

    retrofit2.Response<MapMatchingResponse> generate(retrofit2.Response<MapMatchingResponse> response) {
        if (this.isNotSuccessful(response)) {
            return response;
        }
        return retrofit2.Response.success((Object)((MapMatchingResponse)response.body()).toBuilder().matchings(this.generateRouteOptions(response)).build(), (Response)new Response.Builder().code(200).message("OK").protocol(response.raw().protocol()).headers(response.headers()).request(response.raw().request()).build());
    }
}

