/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matrix.v1;

import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.matrix.v1.AutoValue_MapboxMatrix;
import com.mapbox.api.matrix.v1.MatrixAdapterFactory;
import com.mapbox.api.matrix.v1.MatrixService;
import com.mapbox.api.matrix.v1.models.MatrixResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;

public abstract class MapboxMatrix
extends MapboxService<MatrixResponse, MatrixService> {
    protected MapboxMatrix() {
        super(MatrixService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxMatrix.Builder().baseUrl("https://api.mapbox.com").profile("driving").user("mapbox");
    }

    abstract String accessToken();

    abstract String annotations();

    abstract String approaches();

    @Override
    protected abstract String baseUrl();

    abstract String clientAppName();

    abstract String coordinates();

    abstract String destinations();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(MatrixAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    @Override
    protected Call<MatrixResponse> initializeCall() {
        return ((MatrixService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.annotations(), this.approaches(), this.destinations(), this.sources());
    }

    abstract String profile();

    abstract String sources();

    abstract String user();

    public static abstract class Builder {
        private String[] annotations;
        private String[] approaches;
        private Integer coordinateListSizeLimit;
        private List<Point> coordinates = new ArrayList<Point>();
        private Integer[] destinations;
        private Integer[] sources;

        private static String formatCoordinates(List<Point> object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<Point> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(((Point)object).longitude()), FormatUtils.formatCoordinate(((Point)object).latitude())));
            }
            return TextUtils.join(";", arrayList.toArray());
        }

        public abstract Builder accessToken(String var1);

        public Builder addAnnotations(String ... stringArray) {
            this.annotations = stringArray;
            return this;
        }

        public Builder addApproaches(String ... stringArray) {
            this.approaches = stringArray;
            return this;
        }

        abstract Builder annotations(String var1);

        abstract Builder approaches(String var1);

        abstract MapboxMatrix autoBuild();

        public abstract Builder baseUrl(String var1);

        public MapboxMatrix build() {
            Object object = this.coordinates;
            if (object != null && object.size() >= 2) {
                object = this.coordinateListSizeLimit;
                if (object != null && (Integer)object < 0) {
                    throw new ServicesException("If you're going to use the coordinateListSizeLimit() method, please pass through a number that's greater than zero.");
                }
                if (this.coordinateListSizeLimit == null && this.coordinates.size() > 25) {
                    throw new ServicesException("A maximum of 25 coordinates is the default  allowed for this API. If your Mapbox account has been enabled by the Mapbox team to make a request with more than 25 coordinates, please use the builder's coordinateListSizeLimit() method and pass through your account-specific maximum.");
                }
                object = this.coordinateListSizeLimit;
                if (object != null && (Integer)object < this.coordinates.size()) {
                    throw new ServicesException("If you're going to use the coordinateListSizeLimit() method, please pass through a number that's equal to or greater than the size of your coordinate list.");
                }
                this.coordinates(Builder.formatCoordinates(this.coordinates));
                this.sources(TextUtils.join(";", this.sources));
                this.destinations(TextUtils.join(";", this.destinations));
                this.annotations(TextUtils.join(",", this.annotations));
                this.approaches(TextUtils.join(";", this.approaches));
                object = this.autoBuild();
                if (MapboxUtils.isAccessTokenValid(((MapboxMatrix)object).accessToken())) {
                    return object;
                }
                throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            }
            throw new ServicesException("At least two coordinates must be provided with your API request.");
        }

        public abstract Builder clientAppName(String var1);

        public Builder coordinate(Point point) {
            this.coordinates.add(point);
            return this;
        }

        public Builder coordinateListSizeLimit(Integer n) {
            this.coordinateListSizeLimit = n;
            return this;
        }

        abstract Builder coordinates(String var1);

        public Builder coordinates(List<Point> list) {
            this.coordinates.addAll(list);
            return this;
        }

        abstract Builder destinations(String var1);

        public Builder destinations(Integer ... integerArray) {
            this.destinations = integerArray;
            return this;
        }

        public abstract Builder profile(String var1);

        abstract Builder sources(String var1);

        public Builder sources(Integer ... integerArray) {
            this.sources = integerArray;
            return this;
        }

        public abstract Builder user(String var1);
    }
}

