/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.optimization.v1;

import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.optimization.v1.AutoValue_MapboxOptimization;
import com.mapbox.api.optimization.v1.OptimizationService;
import com.mapbox.api.optimization.v1.models.OptimizationAdapterFactory;
import com.mapbox.api.optimization.v1.models.OptimizationResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;

public abstract class MapboxOptimization
extends MapboxService<OptimizationResponse, OptimizationService> {
    protected MapboxOptimization() {
        super(OptimizationService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxOptimization.Builder().baseUrl("https://api.mapbox.com").profile("driving").user("mapbox").geometries("polyline6");
    }

    abstract String accessToken();

    abstract String annotations();

    @Override
    protected abstract String baseUrl();

    abstract String bearings();

    abstract String clientAppName();

    abstract String coordinates();

    abstract String destination();

    abstract String distributions();

    abstract String geometries();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(OptimizationAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    @Override
    protected Call<OptimizationResponse> initializeCall() {
        return ((OptimizationService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.roundTrip(), this.radiuses(), this.bearings(), this.steps(), this.overview(), this.geometries(), this.annotations(), this.destination(), this.source(), this.language(), this.distributions());
    }

    abstract String language();

    abstract String overview();

    abstract String profile();

    abstract String radiuses();

    abstract Boolean roundTrip();

    abstract String source();

    abstract Boolean steps();

    abstract String user();

    public static abstract class Builder {
        private String[] annotations;
        private List<List<Double>> bearings;
        private List<Point> coordinates;
        private List<Integer[]> distributions = new ArrayList<Integer[]>();
        private double[] radiuses;

        public Builder() {
            this.bearings = new ArrayList<List<Double>>();
            this.coordinates = new ArrayList<Point>();
        }

        private static String formatCoordinates(List<Point> object) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Point point = (Point)object.next();
                arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(point.longitude()), FormatUtils.formatCoordinate(point.latitude())));
            }
            return TextUtils.join(";", arrayList.toArray());
        }

        public abstract Builder accessToken(String var1);

        abstract Builder annotations(String var1);

        public Builder annotations(String ... stringArray) {
            this.annotations = stringArray;
            return this;
        }

        abstract MapboxOptimization autoBuild();

        public abstract Builder baseUrl(String var1);

        public Builder bearing(Double d, Double d2) {
            this.bearings.add(Arrays.asList(d, d2));
            return this;
        }

        abstract Builder bearings(String var1);

        public MapboxOptimization build() {
            List<Point> list = this.coordinates;
            if (list != null && list.size() >= 2) {
                if (this.coordinates.size() <= 12) {
                    this.coordinates(Builder.formatCoordinates(this.coordinates));
                    this.bearings(FormatUtils.formatBearings(this.bearings));
                    this.annotations(TextUtils.join(",", this.annotations));
                    this.radiuses(TextUtils.formatRadiuses(this.radiuses));
                    this.distributions(FormatUtils.formatDistributions(this.distributions));
                    list = this.autoBuild();
                    if (MapboxUtils.isAccessTokenValid(((MapboxOptimization)((Object)list)).accessToken())) {
                        return list;
                    }
                    throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
                }
                throw new ServicesException("Maximum of 12 coordinates are allowed for this API.");
            }
            throw new ServicesException("At least two coordinates must be provided with your APIrequest.");
        }

        public abstract Builder clientAppName(String var1);

        public Builder coordinate(Point point) {
            this.coordinates.add(point);
            return this;
        }

        abstract Builder coordinates(String var1);

        public Builder coordinates(List<Point> list) {
            this.coordinates.addAll(list);
            return this;
        }

        public abstract Builder destination(String var1);

        public Builder distribution(Integer n, Integer n2) {
            this.distributions.add(new Integer[]{n, n2});
            return this;
        }

        abstract Builder distributions(String var1);

        public abstract Builder geometries(String var1);

        public abstract Builder language(String var1);

        public Builder language(Locale locale) {
            if (locale != null) {
                this.language(locale.getLanguage());
            }
            return this;
        }

        public abstract Builder overview(String var1);

        public abstract Builder profile(String var1);

        abstract Builder radiuses(String var1);

        public Builder radiuses(double ... dArray) {
            this.radiuses = dArray;
            return this;
        }

        public abstract Builder roundTrip(Boolean var1);

        public abstract Builder source(String var1);

        public abstract Builder steps(Boolean var1);

        public abstract Builder user(String var1);
    }
}

