/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.staticmap.v1.models;

import com.mapbox.api.staticmap.v1.models.AutoValue_StaticPolylineAnnotation;
import com.mapbox.core.utils.ColorUtils;

public abstract class StaticPolylineAnnotation {
    public static Builder builder() {
        return new AutoValue_StaticPolylineAnnotation.Builder();
    }

    abstract String fillColor();

    abstract Float fillOpacity();

    abstract String polyline();

    abstract String strokeColor();

    abstract Float strokeOpacity();

    abstract Double strokeWidth();

    public abstract Builder toBuilder();

    public String url() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("path");
        if (this.strokeWidth() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.strokeWidth());
        }
        if (this.strokeColor() != null) {
            stringBuilder.append("+");
            stringBuilder.append(this.strokeColor());
        }
        if (this.strokeOpacity() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.strokeOpacity());
        }
        if (this.fillColor() != null) {
            stringBuilder.append("+");
            stringBuilder.append(this.fillColor());
        }
        if (this.fillOpacity() != null) {
            stringBuilder.append("-");
            stringBuilder.append(this.fillOpacity());
        }
        stringBuilder.append("(");
        stringBuilder.append(this.polyline());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static abstract class Builder {
        public abstract StaticPolylineAnnotation build();

        public Builder fillColor(int n, int n2, int n3) {
            return this.fillColor(ColorUtils.toHexString(n, n2, n3));
        }

        public abstract Builder fillColor(String var1);

        public abstract Builder fillOpacity(Float var1);

        public abstract Builder polyline(String var1);

        public Builder strokeColor(int n, int n2, int n3) {
            return this.strokeColor(ColorUtils.toHexString(n, n2, n3));
        }

        public abstract Builder strokeColor(String var1);

        public abstract Builder strokeOpacity(Float var1);

        public abstract Builder strokeWidth(Double var1);
    }
}

