/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.Objects;

public final class Feature
implements GeoJson {
    private static final String TYPE = "Feature";
    @JsonAdapter(value=BoundingBoxTypeAdapter.class)
    private final BoundingBox bbox;
    private final Geometry geometry;
    private final String id;
    private final JsonObject properties;
    private final String type;

    Feature(String string2, BoundingBox boundingBox, String string3, Geometry geometry, JsonObject jsonObject) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        this.id = string3;
        this.geometry = geometry;
        this.properties = jsonObject;
    }

    public static Feature fromGeometry(Geometry geometry) {
        return new Feature(TYPE, null, null, geometry, new JsonObject());
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject jsonObject) {
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject == null) {
            jsonObject2 = new JsonObject();
        }
        return new Feature(TYPE, null, null, geometry, jsonObject2);
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject jsonObject, BoundingBox boundingBox) {
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject == null) {
            jsonObject2 = new JsonObject();
        }
        return new Feature(TYPE, boundingBox, null, geometry, jsonObject2);
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject jsonObject, String string2) {
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject == null) {
            jsonObject2 = new JsonObject();
        }
        return new Feature(TYPE, null, string2, geometry, jsonObject2);
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject jsonObject, String string2, BoundingBox boundingBox) {
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject == null) {
            jsonObject2 = new JsonObject();
        }
        return new Feature(TYPE, boundingBox, string2, geometry, jsonObject2);
    }

    public static Feature fromGeometry(Geometry geometry, BoundingBox boundingBox) {
        return new Feature(TYPE, boundingBox, null, geometry, new JsonObject());
    }

    public static Feature fromJson(String object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gsonBuilder.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        object = gsonBuilder.create().fromJson((String)object, Feature.class);
        if (((Feature)object).properties() != null) {
            return object;
        }
        return new Feature(TYPE, ((Feature)object).bbox(), ((Feature)object).id(), ((Feature)object).geometry(), new JsonObject());
    }

    public static TypeAdapter<Feature> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public void addBooleanProperty(String string2, Boolean bl) {
        this.properties().addProperty(string2, bl);
    }

    public void addCharacterProperty(String string2, Character c) {
        this.properties().addProperty(string2, c);
    }

    public void addNumberProperty(String string2, Number number) {
        this.properties().addProperty(string2, number);
    }

    public void addProperty(String string2, JsonElement jsonElement) {
        this.properties().add(string2, jsonElement);
    }

    public void addStringProperty(String string2, String string3) {
        this.properties().addProperty(string2, string3);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof Feature) {
            Object object2;
            if (!(this.type.equals(((Feature)(object = (Feature)object)).type()) && ((object2 = this.bbox) == null ? ((Feature)object).bbox() == null : ((BoundingBox)object2).equals(((Feature)object).bbox())) && ((object2 = this.id) == null ? ((Feature)object).id() == null : ((String)object2).equals(((Feature)object).id())) && ((object2 = this.geometry) == null ? ((Feature)object).geometry() == null : object2.equals(((Feature)object).geometry())) && ((object2 = this.properties) == null ? ((Feature)object).properties() == null : ((JsonObject)object2).equals(((Feature)object).properties())))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public Geometry geometry() {
        return this.geometry;
    }

    public Boolean getBooleanProperty(String object) {
        object = this.properties().get((String)object);
        object = object == null ? null : Boolean.valueOf(((JsonElement)object).getAsBoolean());
        return object;
    }

    public Character getCharacterProperty(String object) {
        object = this.properties().get((String)object);
        object = object == null ? null : Character.valueOf(((JsonElement)object).getAsCharacter());
        return object;
    }

    public Number getNumberProperty(String object) {
        object = this.properties().get((String)object);
        object = object == null ? null : ((JsonElement)object).getAsNumber();
        return object;
    }

    public JsonElement getProperty(String string2) {
        return this.properties().get(string2);
    }

    public String getStringProperty(String object) {
        object = this.properties().get((String)object);
        object = object == null ? null : ((JsonElement)object).getAsString();
        return object;
    }

    public boolean hasNonNullValueForProperty(String string2) {
        boolean bl = this.hasProperty(string2) && !this.getProperty(string2).isJsonNull();
        return bl;
    }

    public boolean hasProperty(String string2) {
        return this.properties().has(string2);
    }

    public int hashCode() {
        int n = this.type.hashCode();
        Object object = this.bbox;
        int n2 = 0;
        int n3 = object == null ? 0 : ((BoundingBox)object).hashCode();
        object = this.id;
        int n4 = object == null ? 0 : ((String)object).hashCode();
        object = this.geometry;
        int n5 = object == null ? 0 : object.hashCode();
        object = this.properties;
        if (object != null) {
            n2 = ((JsonObject)object).hashCode();
        }
        return ((((n ^ 0xF4243) * 1000003 ^ n3) * 1000003 ^ n4) * 1000003 ^ n5) * 1000003 ^ n2;
    }

    public String id() {
        return this.id;
    }

    public JsonObject properties() {
        return this.properties;
    }

    public JsonElement removeProperty(String string2) {
        return this.properties().remove(string2);
    }

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create()).create();
        Feature feature = this.properties().size() == 0 ? new Feature(TYPE, this.bbox(), this.id(), this.geometry(), null) : this;
        return gson.toJson(feature);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Feature{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", geometry=");
        stringBuilder.append(this.geometry);
        stringBuilder.append(", properties=");
        stringBuilder.append(this.properties);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<Feature> {
        private volatile TypeAdapter<BoundingBox> boundingBoxTypeAdapter;
        private volatile TypeAdapter<Geometry> geometryTypeAdapter;
        private final Gson gson;
        private volatile TypeAdapter<JsonObject> jsonObjectTypeAdapter;
        private volatile TypeAdapter<String> stringTypeAdapter;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        @Override
        public Feature read(JsonReader jsonReader) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            Object object5 = object4 = (object3 = (object2 = (object = null)));
            block14: while (jsonReader.hasNext()) {
                TypeAdapter<Object> typeAdapter = jsonReader.nextName();
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                ((String)((Object)typeAdapter)).hashCode();
                int n = -1;
                switch (((String)((Object)typeAdapter)).hashCode()) {
                    default: {
                        break;
                    }
                    case 1846020210: {
                        if (!((String)((Object)typeAdapter)).equals("geometry")) break;
                        n = 4;
                        break;
                    }
                    case 3575610: {
                        if (!((String)((Object)typeAdapter)).equals("type")) break;
                        n = 3;
                        break;
                    }
                    case 3017257: {
                        if (!((String)((Object)typeAdapter)).equals("bbox")) break;
                        n = 2;
                        break;
                    }
                    case 3355: {
                        if (!((String)((Object)typeAdapter)).equals("id")) break;
                        n = 1;
                        break;
                    }
                    case -926053069: {
                        if (!((String)((Object)typeAdapter)).equals("properties")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        jsonReader.skipValue();
                        continue block14;
                    }
                    case 4: {
                        typeAdapter = this.geometryTypeAdapter;
                        object4 = typeAdapter;
                        if (typeAdapter == null) {
                            this.geometryTypeAdapter = object4 = this.gson.getAdapter(Geometry.class);
                        }
                        object4 = (Geometry)((TypeAdapter)object4).read(jsonReader);
                        continue block14;
                    }
                    case 3: {
                        typeAdapter = this.stringTypeAdapter;
                        object = typeAdapter;
                        if (typeAdapter == null) {
                            this.stringTypeAdapter = object = this.gson.getAdapter(String.class);
                        }
                        object = (String)((TypeAdapter)object).read(jsonReader);
                        continue block14;
                    }
                    case 2: {
                        typeAdapter = this.boundingBoxTypeAdapter;
                        object2 = typeAdapter;
                        if (typeAdapter == null) {
                            this.boundingBoxTypeAdapter = object2 = this.gson.getAdapter(BoundingBox.class);
                        }
                        object2 = (BoundingBox)((TypeAdapter)object2).read(jsonReader);
                        continue block14;
                    }
                    case 1: {
                        typeAdapter = this.stringTypeAdapter;
                        object3 = typeAdapter;
                        if (typeAdapter == null) {
                            this.stringTypeAdapter = object3 = this.gson.getAdapter(String.class);
                        }
                        object3 = (String)((TypeAdapter)object3).read(jsonReader);
                        continue block14;
                    }
                    case 0: 
                }
                typeAdapter = this.jsonObjectTypeAdapter;
                object5 = typeAdapter;
                if (typeAdapter == null) {
                    this.jsonObjectTypeAdapter = object5 = this.gson.getAdapter(JsonObject.class);
                }
                object5 = (JsonObject)((TypeAdapter)object5).read(jsonReader);
            }
            jsonReader.endObject();
            return new Feature((String)object, (BoundingBox)object2, (String)object3, (Geometry)object4, (JsonObject)object5);
        }

        @Override
        public void write(JsonWriter jsonWriter, Feature feature) throws IOException {
            TypeAdapter<Object> typeAdapter;
            TypeAdapter<Object> typeAdapter2;
            if (feature == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (feature.type() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.stringTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(String.class);
                    this.stringTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, feature.type());
            }
            jsonWriter.name("bbox");
            if (feature.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.boundingBoxTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(BoundingBox.class);
                    this.boundingBoxTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, (String)((Object)feature.bbox()));
            }
            jsonWriter.name("id");
            if (feature.id() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.stringTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(String.class);
                    this.stringTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, feature.id());
            }
            jsonWriter.name("geometry");
            if (feature.geometry() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.geometryTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(Geometry.class);
                    this.geometryTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, feature.geometry());
            }
            jsonWriter.name("properties");
            if (feature.properties() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.jsonObjectTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(JsonObject.class);
                    this.jsonObjectTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, feature.properties());
            }
            jsonWriter.endObject();
        }
    }
}

