/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class FeatureCollection
implements GeoJson {
    private static final String TYPE = "FeatureCollection";
    @JsonAdapter(value=BoundingBoxTypeAdapter.class)
    private final BoundingBox bbox;
    private final List<Feature> features;
    private final String type;

    FeatureCollection(String string2, BoundingBox boundingBox, List<Feature> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        this.features = list;
    }

    public static FeatureCollection fromFeature(Feature feature) {
        return new FeatureCollection(TYPE, null, Arrays.asList(feature));
    }

    public static FeatureCollection fromFeature(Feature feature, BoundingBox boundingBox) {
        return new FeatureCollection(TYPE, boundingBox, Arrays.asList(feature));
    }

    public static FeatureCollection fromFeatures(List<Feature> list) {
        return new FeatureCollection(TYPE, null, list);
    }

    public static FeatureCollection fromFeatures(List<Feature> list, BoundingBox boundingBox) {
        return new FeatureCollection(TYPE, boundingBox, list);
    }

    public static FeatureCollection fromFeatures(Feature[] featureArray) {
        return new FeatureCollection(TYPE, null, Arrays.asList(featureArray));
    }

    public static FeatureCollection fromFeatures(Feature[] featureArray, BoundingBox boundingBox) {
        return new FeatureCollection(TYPE, boundingBox, Arrays.asList(featureArray));
    }

    public static FeatureCollection fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gsonBuilder.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, FeatureCollection.class);
    }

    public static TypeAdapter<FeatureCollection> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof FeatureCollection) {
            Object object2;
            if (!(this.type.equals(((FeatureCollection)(object = (FeatureCollection)object)).type()) && ((object2 = this.bbox) == null ? ((FeatureCollection)object).bbox() == null : ((BoundingBox)object2).equals(((FeatureCollection)object).bbox())) && ((object2 = this.features) == null ? ((FeatureCollection)object).features() == null : object2.equals(((FeatureCollection)object).features())))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public List<Feature> features() {
        return this.features;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        List<Feature> list = this.bbox;
        int n2 = 0;
        int n3 = list == null ? 0 : ((BoundingBox)((Object)list)).hashCode();
        list = this.features;
        if (list != null) {
            n2 = list.hashCode();
        }
        return ((n ^ 0xF4243) * 1000003 ^ n3) * 1000003 ^ n2;
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gsonBuilder.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("FeatureCollection{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", features=");
        stringBuilder.append(this.features);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<FeatureCollection> {
        private volatile TypeAdapter<BoundingBox> boundingBoxAdapter;
        private final Gson gson;
        private volatile TypeAdapter<List<Feature>> listFeatureAdapter;
        private volatile TypeAdapter<String> stringAdapter;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        @Override
        public FeatureCollection read(JsonReader jsonReader) throws IOException {
            Object object = jsonReader.peek();
            Object object2 = JsonToken.NULL;
            Object object3 = null;
            if (object == object2) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            object2 = object = null;
            block10: while (jsonReader.hasNext()) {
                TypeAdapter<Object> typeAdapter = jsonReader.nextName();
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                ((String)((Object)typeAdapter)).hashCode();
                int n = -1;
                switch (((String)((Object)typeAdapter)).hashCode()) {
                    default: {
                        break;
                    }
                    case 3575610: {
                        if (!((String)((Object)typeAdapter)).equals("type")) break;
                        n = 2;
                        break;
                    }
                    case 3017257: {
                        if (!((String)((Object)typeAdapter)).equals("bbox")) break;
                        n = 1;
                        break;
                    }
                    case -290659267: {
                        if (!((String)((Object)typeAdapter)).equals("features")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        jsonReader.skipValue();
                        continue block10;
                    }
                    case 2: {
                        typeAdapter = this.stringAdapter;
                        object3 = typeAdapter;
                        if (typeAdapter == null) {
                            this.stringAdapter = object3 = this.gson.getAdapter(String.class);
                        }
                        object3 = (String)((TypeAdapter)object3).read(jsonReader);
                        continue block10;
                    }
                    case 1: {
                        typeAdapter = this.boundingBoxAdapter;
                        object = typeAdapter;
                        if (typeAdapter == null) {
                            this.boundingBoxAdapter = object = this.gson.getAdapter(BoundingBox.class);
                        }
                        object = (BoundingBox)((TypeAdapter)object).read(jsonReader);
                        continue block10;
                    }
                    case 0: 
                }
                typeAdapter = this.listFeatureAdapter;
                object2 = typeAdapter;
                if (typeAdapter == null) {
                    object2 = TypeToken.getParameterized(List.class, new Type[]{Feature.class});
                    this.listFeatureAdapter = object2 = this.gson.getAdapter(object2);
                }
                object2 = (List)((TypeAdapter)object2).read(jsonReader);
            }
            jsonReader.endObject();
            return new FeatureCollection((String)object3, (BoundingBox)object, (List<Feature>)object2);
        }

        @Override
        public void write(JsonWriter jsonWriter, FeatureCollection featureCollection) throws IOException {
            TypeAdapter typeAdapter;
            TypeAdapter<Object> typeAdapter2;
            if (featureCollection == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (featureCollection.type() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.stringAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(String.class);
                    this.stringAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, (String)featureCollection.type());
            }
            jsonWriter.name("bbox");
            if (featureCollection.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.boundingBoxAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(BoundingBox.class);
                    this.boundingBoxAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, (String)((Object)featureCollection.bbox()));
            }
            jsonWriter.name("features");
            if (featureCollection.features() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.listFeatureAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = TypeToken.getParameterized(List.class, new Type[]{Feature.class});
                    typeAdapter = this.gson.getAdapter(typeAdapter);
                    this.listFeatureAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, featureCollection.features());
            }
            jsonWriter.endObject();
        }
    }
}

