/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import com.mapbox.geojson.utils.GeoJsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BoundingBoxTypeAdapter
extends TypeAdapter<BoundingBox> {
    @Override
    public BoundingBox read(JsonReader jsonReader) throws IOException {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList.add(jsonReader.nextDouble());
        }
        jsonReader.endArray();
        if (arrayList.size() == 6) {
            return BoundingBox.fromLngLats((Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3), (Double)arrayList.get(4), (Double)arrayList.get(5));
        }
        if (arrayList.size() == 4) {
            return BoundingBox.fromLngLats((Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3));
        }
        throw new GeoJsonException("The value of the bbox member MUST be an array of length 2*n where n is the number of dimensions represented in the contained geometries,with all axes of the most southwesterly point followed  by all axes of the more northeasterly point. The axes order of a bbox follows the axes order of geometries.");
    }

    @Override
    public void write(JsonWriter jsonWriter, BoundingBox serializable) throws IOException {
        if (serializable == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        Point point = ((BoundingBox)serializable).southwest();
        List<Double> list = CoordinateShifterManager.getCoordinateShifter().unshiftPoint(point);
        jsonWriter.value(GeoJsonUtils.trim(list.get(0)));
        jsonWriter.value(GeoJsonUtils.trim(list.get(1)));
        if (point.hasAltitude()) {
            jsonWriter.value(list.get(2));
        }
        serializable = ((BoundingBox)serializable).northeast();
        list = CoordinateShifterManager.getCoordinateShifter().unshiftPoint((Point)serializable);
        jsonWriter.value(GeoJsonUtils.trim(list.get(0)));
        jsonWriter.value(GeoJsonUtils.trim(list.get(1)));
        if (((Point)serializable).hasAltitude()) {
            jsonWriter.value(list.get(2));
        }
        jsonWriter.endArray();
    }
}

