/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.shifter;

import com.mapbox.geojson.Point;
import com.mapbox.geojson.shifter.CoordinateShifter;
import java.util.Arrays;
import java.util.List;

public final class CoordinateShifterManager {
    private static final CoordinateShifter DEFAULT;
    private static volatile CoordinateShifter coordinateShifter;

    static {
        CoordinateShifter coordinateShifter;
        DEFAULT = coordinateShifter = new CoordinateShifter(){

            @Override
            public List<Double> shiftLonLat(double d, double d2) {
                return Arrays.asList(d, d2);
            }

            @Override
            public List<Double> shiftLonLatAlt(double d, double d2, double d3) {
                List<Double> list = Double.isNaN(d3) ? Arrays.asList(d, d2) : Arrays.asList(d, d2, d3);
                return list;
            }

            @Override
            public List<Double> unshiftPoint(Point point) {
                return point.coordinates();
            }

            @Override
            public List<Double> unshiftPoint(List<Double> list) {
                return list;
            }
        };
        CoordinateShifterManager.coordinateShifter = coordinateShifter;
    }

    public static CoordinateShifter getCoordinateShifter() {
        return coordinateShifter;
    }

    public static boolean isUsingDefaultShifter() {
        boolean bl = coordinateShifter == DEFAULT;
        return bl;
    }

    public static void setCoordinateShifter(CoordinateShifter coordinateShifter) {
        CoordinateShifter coordinateShifter2 = coordinateShifter;
        if (coordinateShifter == null) {
            coordinateShifter2 = DEFAULT;
        }
        CoordinateShifterManager.coordinateShifter = coordinateShifter2;
    }
}

