/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.utils;

import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PolylineUtils {
    private static final boolean SIMPLIFY_DEFAULT_HIGHEST_QUALITY = false;
    private static final double SIMPLIFY_DEFAULT_TOLERANCE = 1.0;

    private PolylineUtils() {
    }

    public static List<Point> decode(String string2, int n) {
        int n2 = string2.length();
        double d = Math.pow(10.0, n);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        n = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (n < n2) {
            int n5 = 1;
            int n6 = 0;
            int n7 = n;
            while (true) {
                n = n7 + 1;
                n7 = string2.charAt(n7) - 63 - 1;
                n5 += n7 << n6;
                n6 += 5;
                if (n7 < 31) {
                    n6 = (n5 & 1) != 0 ? n5 >> 1 : n5 >> 1;
                    n7 = n6 + n3;
                    n6 = 1;
                    n3 = 0;
                    n5 = n;
                    while (true) {
                        n = n5 + 1;
                        n5 = string2.charAt(n5) - 63 - 1;
                        n6 += n5 << n3;
                        n3 += 5;
                        if (n5 < 31) {
                            n3 = n5 = n6 >> 1;
                            if ((n6 & 1) != 0) {
                                n3 = n5;
                            }
                            arrayList.add(Point.fromLngLat((double)(n4 += n3) / d, (double)n7 / d));
                            n3 = n7;
                            continue block0;
                        }
                        n5 = n;
                    }
                }
                n7 = n;
            }
        }
        return arrayList;
    }

    public static String encode(List<Point> object, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        double d = Math.pow(10.0, n);
        Iterator<Point> iterator2 = object.iterator();
        long l = 0L;
        long l2 = 0L;
        while (iterator2.hasNext()) {
            object = iterator2.next();
            long l3 = Math.round(((Point)object).latitude() * d);
            long l4 = Math.round(((Point)object).longitude() * d);
            PolylineUtils.encode(l3 - l, stringBuilder);
            PolylineUtils.encode(l4 - l2, stringBuilder);
            l = l3;
            l2 = l4;
        }
        return stringBuilder.toString();
    }

    private static void encode(long l, StringBuilder stringBuilder) {
        long l2;
        long l3 = l2 = l << 1;
        if (l < 0L) {
            l3 = l2;
        }
        while (l3 >= 32L) {
            stringBuilder.append(Character.toChars((int)((0x20L | 0x1FL & l3) + 63L)));
            l3 >>= 5;
        }
        stringBuilder.append(Character.toChars((int)(l3 + 63L)));
    }

    private static double getSqDist(Point point, Point point2) {
        double d = point.longitude() - point2.longitude();
        double d2 = point.latitude() - point2.latitude();
        return d * d + d2 * d2;
    }

    private static double getSqSegDist(Point point, Point point2, Point point3) {
        double d;
        double d2;
        block7: {
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            block6: {
                d7 = point2.longitude();
                d6 = point2.latitude();
                d5 = point3.longitude() - d7;
                d4 = point3.latitude() - d6;
                if (d5 != 0.0) break block6;
                d2 = d7;
                d = d6;
                if (d4 == 0.0) break block7;
            }
            if ((d3 = ((point.longitude() - d7) * d5 + (point.latitude() - d6) * d4) / (d5 * d5 + d4 * d4)) > 1.0) {
                d2 = point3.longitude();
                d = point3.latitude();
            } else {
                d2 = d7;
                d = d6;
                if (d3 > 0.0) {
                    d2 = d7 + d5 * d3;
                    d = d6 + d4 * d3;
                }
            }
        }
        d2 = point.longitude() - d2;
        d = point.latitude() - d;
        return d2 * d2 + d * d;
    }

    public static List<Point> simplify(List<Point> list) {
        return PolylineUtils.simplify(list, 1.0, false);
    }

    public static List<Point> simplify(List<Point> list, double d) {
        return PolylineUtils.simplify(list, d, false);
    }

    public static List<Point> simplify(List<Point> list, double d, boolean bl) {
        if (list.size() <= 2) {
            return list;
        }
        d *= d;
        if (!bl) {
            list = PolylineUtils.simplifyRadialDist(list, d);
        }
        return PolylineUtils.simplifyDouglasPeucker(list, d);
    }

    public static List<Point> simplify(List<Point> list, boolean bl) {
        return PolylineUtils.simplify(list, 1.0, bl);
    }

    private static List<Point> simplifyDouglasPeucker(List<Point> list, double d) {
        int n = list.size() - 1;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(list.get(0));
        arrayList.addAll(PolylineUtils.simplifyDpStep(list, 0, n, d, arrayList));
        arrayList.add(list.get(n));
        return arrayList;
    }

    private static List<Point> simplifyDpStep(List<Point> list, int n, int n2, double d, List<Point> list2) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        double d2 = d;
        int n3 = 0;
        for (int i = n + 1; i < n2; ++i) {
            double d3 = PolylineUtils.getSqSegDist(list.get(i), list.get(n), list.get(n2));
            double d4 = d2;
            if (d3 > d2) {
                n3 = i;
                d4 = d3;
            }
            d2 = d4;
        }
        if (d2 > d) {
            if (n3 - n > 1) {
                arrayList.addAll(PolylineUtils.simplifyDpStep(list, n, n3, d, list2));
            }
            arrayList.add(list.get(n3));
            if (n2 - n3 > 1) {
                arrayList.addAll(PolylineUtils.simplifyDpStep(list, n3, n2, d, list2));
            }
        }
        return arrayList;
    }

    private static List<Point> simplifyRadialDist(List<Point> list, double d) {
        Point point = list.get(0);
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(point);
        int n = list.size();
        Point point2 = null;
        for (int i = 1; i < n; ++i) {
            point2 = list.get(i);
            Point point3 = point;
            if (PolylineUtils.getSqDist(point2, point) > d) {
                arrayList.add(point2);
                point3 = point2;
            }
            point = point3;
        }
        if (!point.equals(point2)) {
            arrayList.add(point2);
        }
        return arrayList;
    }
}

