/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.mapbox.android.accounts.v1.MapboxAccounts;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.log.Logger;

class AccountsManager {
    private static final String PREFERENCE_TIMESTAMP = "com.mapbox.mapboxsdk.accounts.timestamp";
    private static final String PREFERENCE_USER_ID = "com.mapbox.mapboxsdk.accounts.userid";
    private static final String TAG = "Mbgl-AccountsManager";
    private boolean isManaged;
    private SharedPreferences sharedPreferences;
    private String skuToken;
    private long timestamp;
    private String userId;

    AccountsManager() {
        this.isManaged = this.isSkuTokenManaged();
        this.initialize();
    }

    AccountsManager(SharedPreferences sharedPreferences, boolean bl) {
        this.sharedPreferences = sharedPreferences;
        this.isManaged = bl;
        this.initialize();
    }

    private String generateSkuToken(String string2) {
        return MapboxAccounts.obtainMapsSkuUserToken(string2);
    }

    private String generateUserId() {
        return MapboxAccounts.obtainEndUserId();
    }

    static long getNow() {
        return System.currentTimeMillis();
    }

    private SharedPreferences getSharedPreferences() {
        if (this.sharedPreferences == null) {
            this.sharedPreferences = Mapbox.getApplicationContext().getSharedPreferences("MapboxSharedPreferences", 0);
        }
        return this.sharedPreferences;
    }

    private String getUserId() {
        synchronized (this) {
            String string2;
            block6: {
                if (TextUtils.isEmpty((CharSequence)this.userId)) break block6;
                String string3 = this.userId;
                return string3;
            }
            this.userId = string2 = this.getSharedPreferences().getString(PREFERENCE_USER_ID, "");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                this.userId = this.generateUserId();
                string2 = this.getSharedPreferences().edit();
                string2.putString(PREFERENCE_USER_ID, this.userId);
                if (!string2.commit()) {
                    Logger.e(TAG, "Failed to save user id.");
                }
            }
            string2 = this.userId;
            return string2;
        }
    }

    private void initialize() {
        this.retrieveSkuTokenAndTimestamp();
        if (this.isManaged) {
            this.validateRotation();
        }
    }

    private boolean isExpired() {
        return AccountsManager.isExpired(AccountsManager.getNow(), this.timestamp);
    }

    static boolean isExpired(long l, long l2) {
        boolean bl = l - l2 > 3600000L;
        return bl;
    }

    private boolean isSkuTokenManaged() {
        boolean bl = true;
        ApplicationInfo applicationInfo = this.retrieveApplicationInfo();
        boolean bl2 = bl;
        try {
            if (applicationInfo.metaData != null) {
                bl2 = applicationInfo.metaData.getBoolean("com.mapbox.ManageSkuToken", true);
            }
        }
        catch (Exception exception) {
            Logger.e(TAG, "Failed to read the package metadata: ", exception);
            bl2 = bl;
        }
        return bl2;
    }

    private long persistRotation(String string2) {
        long l = AccountsManager.getNow();
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putLong(PREFERENCE_TIMESTAMP, l);
        editor.putString("com.mapbox.mapboxsdk.accounts.skutoken", string2);
        editor.apply();
        return l;
    }

    private ApplicationInfo retrieveApplicationInfo() throws PackageManager.NameNotFoundException {
        return Mapbox.getApplicationContext().getPackageManager().getApplicationInfo(Mapbox.getApplicationContext().getPackageName(), 128);
    }

    private void retrieveSkuTokenAndTimestamp() {
        SharedPreferences sharedPreferences = this.getSharedPreferences();
        this.skuToken = sharedPreferences.getString("com.mapbox.mapboxsdk.accounts.skutoken", "");
        this.timestamp = sharedPreferences.getLong(PREFERENCE_TIMESTAMP, 0L);
    }

    private void validateRotation() {
        if (TextUtils.isEmpty((CharSequence)this.skuToken) || this.timestamp == 0L) {
            String string2;
            this.skuToken = string2 = this.generateSkuToken(this.getUserId());
            this.timestamp = this.persistRotation(string2);
        }
    }

    String getSkuToken() {
        if (this.isManaged) {
            if (this.isExpired()) {
                String string2;
                this.skuToken = string2 = this.generateSkuToken(this.getUserId());
                this.timestamp = this.persistRotation(string2);
            }
        } else {
            this.skuToken = this.getSharedPreferences().getString("com.mapbox.mapboxsdk.accounts.skutoken", "");
        }
        return this.skuToken;
    }
}

