/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.Context;
import android.content.res.AssetManager;
import com.mapbox.mapboxsdk.AccountsManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.ModuleProvider;
import com.mapbox.mapboxsdk.ModuleProviderImpl;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.ThreadUtils;

public final class Mapbox {
    private static Mapbox INSTANCE;
    private static final String TAG = "Mbgl-Mapbox";
    private static ModuleProvider moduleProvider;
    private String accessToken;
    private AccountsManager accounts;
    private Context context;
    private TelemetryDefinition telemetry;

    Mapbox(Context context, String string2) {
        this.context = context;
        this.accessToken = string2;
    }

    public static String getAccessToken() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.accessToken;
    }

    public static Context getApplicationContext() {
        Mapbox.validateMapbox();
        return Mapbox.INSTANCE.context;
    }

    private static AssetManager getAssetManager() {
        return Mapbox.getApplicationContext().getResources().getAssets();
    }

    public static Mapbox getInstance(Context object, String object2) {
        synchronized (Mapbox.class) {
            ThreadUtils.init(object);
            ThreadUtils.checkThread(TAG);
            if (INSTANCE == null) {
                object = object.getApplicationContext();
                FileSource.initializeFileDirsPaths(object);
                Object object3 = new Mapbox((Context)object, (String)object2);
                INSTANCE = object3;
                if (Mapbox.isAccessTokenValid((String)object2)) {
                    Mapbox.initializeTelemetry();
                    object2 = INSTANCE;
                    ((Mapbox)object2).accounts = object3 = new AccountsManager();
                }
                ConnectivityReceiver.instance(object);
            }
            object = INSTANCE;
            return object;
        }
    }

    public static ModuleProvider getModuleProvider() {
        if (moduleProvider == null) {
            moduleProvider = new ModuleProviderImpl();
        }
        return moduleProvider;
    }

    public static String getSkuToken() {
        Object object;
        if (Mapbox.hasInstance() && (object = Mapbox.INSTANCE.accounts) != null) {
            return ((AccountsManager)object).getSkuToken();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("A valid access token parameter is required when using a Mapbox service.\nPlease see https://www.mapbox.com/help/create-api-access-token/ to learn how to create one.\nMore information in this guide https://www.mapbox.com/help/first-steps-android-sdk/#access-tokens.Currently provided token is: ");
        ((StringBuilder)object).append(Mapbox.INSTANCE.accessToken);
        throw new MapboxConfigurationException(((StringBuilder)object).toString());
    }

    public static TelemetryDefinition getTelemetry() {
        TelemetryDefinition telemetryDefinition = Mapbox.hasInstance() ? Mapbox.INSTANCE.telemetry : null;
        return telemetryDefinition;
    }

    public static boolean hasInstance() {
        boolean bl = INSTANCE != null;
        return bl;
    }

    private static void initializeTelemetry() {
        try {
            Mapbox.INSTANCE.telemetry = Mapbox.getModuleProvider().obtainTelemetry();
        }
        catch (Exception exception) {
            Logger.e(TAG, "Error occurred while initializing telemetry", exception);
            MapStrictMode.strictModeViolation("Error occurred while initializing telemetry", exception);
        }
    }

    static boolean isAccessTokenValid(String string2) {
        boolean bl;
        block4: {
            block5: {
                boolean bl2 = false;
                if (string2 == null) {
                    return false;
                }
                string2 = string2.trim().toLowerCase(MapboxConstants.MAPBOX_LOCALE);
                bl = bl2;
                if (string2.length() == 0) break block4;
                if (string2.startsWith("pk.")) break block5;
                bl = bl2;
                if (!string2.startsWith("sk.")) break block4;
            }
            bl = true;
        }
        return bl;
    }

    public static Boolean isConnected() {
        synchronized (Mapbox.class) {
            Mapbox.validateMapbox();
            boolean bl = ConnectivityReceiver.instance(Mapbox.INSTANCE.context).isConnected();
            return bl;
        }
    }

    public static void setAccessToken(String string2) {
        Mapbox.validateMapbox();
        Object object = INSTANCE;
        ((Mapbox)object).accessToken = string2;
        object = ((Mapbox)object).telemetry;
        if (object != null) {
            object.disableTelemetrySession();
            Mapbox.INSTANCE.telemetry = null;
        }
        if (Mapbox.isAccessTokenValid(string2)) {
            Mapbox.initializeTelemetry();
            Mapbox.INSTANCE.accounts = new AccountsManager();
        } else {
            Mapbox.INSTANCE.accounts = null;
        }
        FileSource.getInstance(Mapbox.getApplicationContext()).setAccessToken(string2);
    }

    public static void setConnected(Boolean bl) {
        synchronized (Mapbox.class) {
            Mapbox.validateMapbox();
            ConnectivityReceiver.instance(Mapbox.INSTANCE.context).setConnected(bl);
            return;
        }
    }

    private static void validateMapbox() {
        if (INSTANCE != null) {
            return;
        }
        throw new MapboxConfigurationException();
    }
}

